/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import java.util.Iterator;
import org.herac.tuxguitar.song.models.Chord;

public class ChordCreatorUtil {
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private int[] tunning;
    private int[] requiredNotes;
    private int tonic;
    private int fret1;
    private int fret2;

    public ChordCreatorUtil(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        this.tunning = nArray;
        this.requiredNotes = nArray2;
        this.tonic = n;
        this.fret1 = n2;
        this.fret2 = n3;
    }

    public Chord getChord() {
        StringValue stringValue = this.findTonic();
        if (stringValue != null && stringValue.getString() + 1 < this.tunning.length) {
            StringValue stringValue2;
            Chord chord = new Chord(this.tunning.length);
            ArrayList<StringValue> arrayList = new ArrayList<StringValue>();
            arrayList.add(stringValue);
            for (int i = stringValue.getString() + 1; i < this.tunning.length; ++i) {
                stringValue2 = null;
                stringValue2 = this.find(i);
                if (stringValue2 == null) continue;
                arrayList.add(stringValue2);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringValue2 = (StringValue)iterator.next();
                int n = chord.getStrings().length - 1 - stringValue2.getString();
                int n2 = stringValue2.getFret();
                chord.addFretValue(n, n2);
            }
            if ((chord = this.check(chord)).count() > 2) {
                return chord;
            }
        }
        return null;
    }

    private StringValue findTonic() {
        for (int i = 0; i < this.tunning.length; ++i) {
            for (int j = this.fret1; j <= this.fret2; ++j) {
                for (int k = 0; k < 10; ++k) {
                    int n = this.tonic - 1 + k * 12;
                    if (this.tunning[i] + j != n) continue;
                    return new StringValue(i, j);
                }
            }
        }
        return null;
    }

    private StringValue find(int n) {
        StringValue stringValue = null;
        for (int i = this.fret1; i <= this.fret2; ++i) {
            StringValue stringValue2 = this.findRequiredNote(n, i);
            if (stringValue2 == null) continue;
            if (stringValue == null) {
                stringValue = stringValue2;
                continue;
            }
            if (!this.hasPriority(stringValue2, stringValue)) continue;
            stringValue = stringValue2;
        }
        return stringValue;
    }

    private StringValue findRequiredNote(int n, int n2) {
        for (int i = 0; i < this.requiredNotes.length; ++i) {
            for (int j = 0; j < 10; ++j) {
                int n3 = this.tonic - 1 + j * 12;
                int n4 = n3 + (this.requiredNotes[i] - 1);
                if (this.tunning[n] + n2 != n4) continue;
                return new StringValue(n, n2, i);
            }
        }
        return null;
    }

    private boolean hasPriority(StringValue stringValue, StringValue stringValue2) {
        return stringValue.getRequiredNoteIndex() < stringValue2.getRequiredNoteIndex();
    }

    private Chord check(Chord chord) {
        int n;
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < chord.getStrings().length; ++n2) {
            n = chord.getFretValue(n2);
            if (n3 >= 0 && (n >= n3 || n < 0)) continue;
            n3 = n;
        }
        n2 = 0;
        for (n = 0; n < chord.getStrings().length; ++n) {
            int n4 = chord.getFretValue(n);
            if (n4 <= n3) continue;
            ++n2;
        }
        if (n3 == 0 && n2 > 4 || n3 > 0 && n2 > 3) {
            n = 0;
            Chord chord2 = null;
            for (int i = chord.getStrings().length - 2; i >= 0; --i) {
                int n5 = chord.getFretValue(i);
                if (n != 0) {
                    if (chord2 == null) {
                        for (int j = 0; j < 10; ++j) {
                            int n6 = this.tonic - 1 + j * 12;
                            if (this.tunning[this.tunning.length - i - 1] + n5 != n6) continue;
                            chord2 = new Chord(chord.getStrings().length);
                        }
                    }
                    if (chord2 == null) continue;
                    chord2.addFretValue(i, n5);
                    continue;
                }
                if (n5 < 0) continue;
                n = 1;
            }
            if (chord2 != null) {
                chord = chord2;
            }
        }
        return chord;
    }

    private class StringValue {
        private int string;
        private int fret;
        private int requiredNoteIndex;

        public StringValue(int n, int n2, int n3) {
            this.string = n;
            this.fret = n2;
            this.requiredNoteIndex = n3;
        }

        public StringValue(int n, int n2) {
            this(n, n2, -1);
        }

        public int getString() {
            return this.string;
        }

        public void setString(int n) {
            this.string = n;
        }

        public int getFret() {
            return this.fret;
        }

        public void setFret(int n) {
            this.fret = n;
        }

        public int getRequiredNoteIndex() {
            return this.requiredNoteIndex;
        }

        public void setRequiredNoteIndex(int n) {
            this.requiredNoteIndex = n;
        }
    }
}

