/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;

public class RemoveMeasureAction
extends Action {
    public static final String NAME = "REMOVE_MEASURE";

    public RemoveMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        MeasureCoords measureCoords = caret.getSongTrackCoords().getNextMeasure(caret.getMeasureCoords());
        if (measureCoords == null) {
            measureCoords = caret.getSongTrackCoords().getPrevMeasure(caret.getMeasureCoords());
        }
        if (measureCoords == null) {
            SongCoords songCoords = caret.getSongCoords();
            SongTrackCoords songTrackCoords = caret.getSongTrackCoords();
            SongTrackCoords songTrackCoords2 = caret.getSongCoords().getNextTrack(songTrackCoords);
            if (songTrackCoords2 == null) {
                songTrackCoords2 = caret.getSongCoords().getPrevTrack(songTrackCoords);
            }
            songCoords.removeTrack(songTrackCoords);
            this.updateTablature();
            if (songTrackCoords2 != null) {
                caret.update(songTrackCoords2.getMeasure(caret.getMeasureCoords().getMeasure().getStart()).getMeasure());
            }
        } else {
            caret.getSongCoords().removeMeasure(caret.getMeasureCoords().getMeasure().getStart());
            this.updateTablature();
            caret.update(measureCoords.getMeasure());
        }
        this.redraw();
        return true;
    }
}

