/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.AlertMessage;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.gp.GPFormatException;

public class OpenFileAction
extends Action {
    public static final String NAME = "OPEN_FILE";

    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        MemoryHelper memoryHelper = this.getEditor().getMemoryHelper();
        String[] stringArray = new String[]{"Suported Files (*.tg,*.gp3,*.gp4)"};
        String[] stringArray2 = new String[]{"*.tg;*.gp3;*.gp4"};
        FileChooser fileChooser = new FileChooser(this.getEditor(), stringArray, stringArray2, memoryHelper.getLastChooserPath(), memoryHelper.getFileName());
        final String string = fileChooser.show(4098);
        if (string != null) {
            this.getEditor().getTablature().changeCursor(1);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        OpenFileAction.this.getEditor().getSongManager().open(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        OpenFileAction.this.showErrorMessage(string);
                        fileNotFoundException.printStackTrace();
                    }
                    catch (GPFormatException gPFormatException) {
                        OpenFileAction.this.showErrorMessage(string);
                        gPFormatException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        OpenFileAction.this.showErrorMessage(string);
                        iOException.printStackTrace();
                    }
                    OpenFileAction.this.getEditor().notifyMemoryHelper(string);
                    new SyncThread(OpenFileAction.this.getEditor(), new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            OpenFileAction.access$500(1.access$400(this.this$1)).resetDefaults();
                            OpenFileAction.access$600(1.access$400(this.this$1));
                            OpenFileAction.access$700(1.access$400(this.this$1)).getTablature().changeCursor(0);
                        }
                    }).start();
                }

                static /* synthetic */ OpenFileAction access$400(1 var0) {
                    return var0.OpenFileAction.this;
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String string) {
        new SyncThread(this.getEditor(), new Runnable(){

            public void run() {
                OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                String string3 = "Error Message";
                String string2 = "Cannot Open file: " + string;
                new AlertMessage(OpenFileAction.this.getEditor(), string3, string2, 33).show();
            }
        }).start();
    }

    static /* synthetic */ TablatureEditor access$500(OpenFileAction openFileAction) {
        return openFileAction.getEditor();
    }

    static /* synthetic */ void access$600(OpenFileAction openFileAction) {
        openFileAction.redraw();
    }

    static /* synthetic */ TablatureEditor access$700(OpenFileAction openFileAction) {
        return openFileAction.getEditor();
    }
}

