/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.song.models.Tempo;

public class ChangeTempoAction
extends Action {
    public static final String NAME = "CHANGE_TEMPO";

    public ChangeTempoAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measureCoords != null) {
            final Shell shell2 = new Shell(shell, 67680);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginTop = 20;
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 10;
            shell2.setLayout((Layout)gridLayout);
            shell2.setText(TuxGuitar.getProperty("composition.tempo"));
            Tempo tempo = measureCoords.getMeasure().getTempo();
            Label label = new Label((Composite)shell2, 0);
            label.setText(TuxGuitar.getProperty("composition.tempo"));
            final Text text = new Text((Composite)shell2, 2048);
            text.setLayoutData((Object)new GridData(50, 13));
            text.setText(Integer.toString(tempo.getValue()));
            Button button = new Button((Composite)shell2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)new GridData(128));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = Integer.parseInt(text.getText());
                    Tempo tempo = new Tempo(n);
                    ChangeTempoAction.this.setTempo(tempo);
                    shell2.dispose();
                }
            });
            Button button2 = new Button((Composite)shell2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
        }
    }

    private void setTempo(Tempo tempo) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        songCoords.changeTempo(measureCoords.getMeasure().getStart(), tempo, true);
        this.updateTablature();
        caret.update(caret.getMeasureCoords().getMeasure());
        this.redraw();
    }
}

