/*
 * Created on 23-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.Test;
import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.SongPlayer;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongManager {
    private static int MAX_CHANNELS = 15;
    
    private Song song;
    private Player player;
    
    public SongManager(){               
        this.player = new SongPlayer(this);
        setSong(Test.getSong());
    }
    
    public void addTrack(SongTrack track){
        getSong().getTracks().add(track);
    }
    
    public void setSongName(String name){
        getSong().setName(name);
    }
    
    public Song getSong(){
        return this.song;
    }
    
    public void newSong(){
        setSong(Test.getSong());        
    }
    
    public void save(String fileName){                        
        try {
            new TGOutputStream(fileName).write(getSong());            
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }         
    }
    
    public void open(String fileName) throws GPFormatException, IOException{
        SongLoader loader = new SongLoader(fileName);
        Song song = loader.load();
        if(song != null){
            setSong(song);
        }            
    }        

    public void setSong(Song song){
        this.song = song;
        this.player.reset();
    }
    
    public Player getPlayer(){
        return this.player;
    }
    
    public SongTrack getTrack(Measure measure){
        SongTrack track = null;
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack currTrack = (SongTrack)it.next();
            if(currTrack.getMeasures().contains(measure)){
                track = currTrack;
                break;
            }
        }
        return track;
    }
    
    

    
    public int getFreeChannel(int instrument,boolean isPercusion){
        return getFreeChannel(getSong().getTracks(),instrument,isPercusion);
    }
    
    public static int getFreeChannel(List tracks,int instrument,boolean isPercusion){
        if(isPercusion){
            return SongTrack.getDefaultPercusionChannel();
        }
        int channel = 0;
        boolean findChannel = false;
        while(!findChannel){
            findChannel = true;
            for(int i = 0;i < tracks.size();i++){
                SongTrack track = (SongTrack)tracks.get(i);
                if(track.getChannel() == channel && track.getInstrument() != instrument){
                    findChannel = false;
                }
            }
            if(!findChannel){
                channel ++;
            	if(channel == SongTrack.getDefaultPercusionChannel()){
                	channel ++;
            	}
            }
            if(channel > MAX_CHANNELS){
                break;
            }
        }
        return channel;
    }        
    
    
    
    public static List createDefaultInstrumentStrings(){
        List strings = new ArrayList();        
        strings.add(new InstrumentString(1, 64));
        strings.add(new InstrumentString(2, 59));
        strings.add(new InstrumentString(3, 55));
        strings.add(new InstrumentString(4, 50));
        strings.add(new InstrumentString(5, 45));
        strings.add(new InstrumentString(6, 40));
        return strings;
    }
    
    public static List createPercusionStrings(){
        List strings = new ArrayList();      
        for(int i = 1;i <= 6; i++){
            strings.add(new InstrumentString(i, 0));
        }
        return strings;
    }        
    
    public void calculateMeasureStartWidthRepetitions(){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack songTrack = (SongTrack)it.next();
            calculateMeasureStartWidthRepetitions(songTrack);
        }
    }
    
    private void calculateMeasureStartWidthRepetitions(SongTrack songTrack){
        boolean repeatOpen = true;
        long repeatStart = 1000;
        
        long repeatEnd = 0;
        long startMove = 0;
        int repeatStartIndex = 0;
        int repeatNumber = 0;

        Measure prevMeasure = null;
        for (int measureIdx = 0; measureIdx < songTrack.getMeasures().size(); measureIdx++) {
            Measure measure = (Measure) songTrack.getMeasures().get(measureIdx);
            
            //asigno el start con repeticiones
            if(!repeatOpen || measure.getStart() + measure.getLength() > repeatEnd){
                measure.setStartWidthRepetitions(measure.getStart() + startMove);
                //calculo las notas dentro del compas
                calculateNoteStartWidthRepetitions(measure,startMove);
            }            

            //guardo el indice de el compas donde empieza una repeticion
            if (measure.isRepeatStart()) {
                repeatStartIndex = measureIdx;                
                repeatStart = measure.getStart();
                repeatOpen = true;
            }

            //si hay una repeticion la hago
            if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
                if (repeatNumber < measure.getNumberOfRepetitions()) {
                    repeatEnd = measure.getStart() + measure.getLength();
                    startMove += repeatEnd - repeatStart;
                    measureIdx = repeatStartIndex - 1;
                    repeatNumber++;
                } else {
                    repeatStart = 0;
                    repeatNumber = 0;
                    repeatEnd = 0;
                    repeatOpen = false;
                }
            }

            prevMeasure = measure;
        }        
    }
    
    private void calculateNoteStartWidthRepetitions(Measure measure,long startMove) {
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            //asigno el start con repeticiones           
            note.setStartWidthRepetitions(note.getStart() + startMove);
        }

    }    
}
