/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetEighthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetHalfDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetQuarterDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixteenthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixtyFourthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetThirtySecondDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetWholeDurationAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.song.models.Duration;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DurationToolItems  implements ItemContainer{
    public static final String NAME = "DURATION_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;   
    private ToolItem[] durationItems; 
    private ToolItem dotted;
    private ToolItem tupleto;
    public DurationToolItems(TablatureEditor tablatureEditor,ToolBar toolBar){
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
        this.durationItems = new ToolItem[7];
    }
   
    public void showItems(){                       
        durationItems[0] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[0].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "1.png")));
        durationItems[0].setToolTipText("Redonda");        
        durationItems[0].addSelectionListener(TuxGuitar.instance().getAction(SetWholeDurationAction.NAME));
        
        durationItems[1] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[1].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "2.png")));
        durationItems[1].setToolTipText("Blanca");        
        durationItems[1].addSelectionListener(TuxGuitar.instance().getAction(SetHalfDurationAction.NAME));
        
        durationItems[2] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[2].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "4.png")));
        durationItems[2].setToolTipText("Negra");
        durationItems[2].setSelection(true);
        durationItems[2].addSelectionListener(TuxGuitar.instance().getAction(SetQuarterDurationAction.NAME));
        
        durationItems[3] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[3].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "8.png")));        
        durationItems[3].setToolTipText("Corchea");
        durationItems[3].addSelectionListener(TuxGuitar.instance().getAction(SetEighthDurationAction.NAME));
        
        durationItems[4] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[4].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "16.png")));
        durationItems[4].setToolTipText("Semi-Corchea");
        durationItems[4].addSelectionListener(TuxGuitar.instance().getAction(SetSixteenthDurationAction.NAME));
        
        durationItems[5] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[5].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "32.png")));
        durationItems[5].setToolTipText("Fusa");
        durationItems[5].addSelectionListener(TuxGuitar.instance().getAction(SetThirtySecondDurationAction.NAME));
        
        durationItems[6] = new ToolItem(toolBar, SWT.RADIO);
        durationItems[6].setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "64.png")));
        durationItems[6].setToolTipText("Semi-Fusa");
        durationItems[6].addSelectionListener(TuxGuitar.instance().getAction(SetSixtyFourthDurationAction.NAME));        
        
        final ToolItem separator = new ToolItem(toolBar, SWT.SEPARATOR);
        
        dotted = new ToolItem(toolBar, SWT.CHECK);
        dotted.setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "dotted.png")));
        dotted.setToolTipText("Puntillo");
        dotted.addSelectionListener(TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));
        
        tupleto = new ToolItem(toolBar, SWT.CHECK);
        tupleto.setImage(new Image(toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "tupleto.png")));
        tupleto.setToolTipText("Tupleto");        
        tupleto.addSelectionListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));    
    }

    
    public void update(){
        Duration duration = tablatureEditor.getTablature().getCaret().getDuration();
        
        for(int i = 0;i < this.durationItems.length;i++){
            this.durationItems[i].setSelection(false);
        }        
        
        int index = 0;
        int value = duration.getValue();        
        while(value > 1){
            value = value / 2;
            index ++;
        }
        this.durationItems[index].setSelection(true);
        this.dotted.setSelection(duration.isDotted());
        this.tupleto.setSelection(!duration.getTupleto().isEqual(Duration.NO_TUPLETO));
    }
}

