/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.AlertMessage;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.gp.GPFormatException;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class OpenFileAction extends Action {
    public static final String NAME = "OPEN_FILE";

    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        MemoryHelper memory = getEditor().getMemoryHelper();
        String[] filterNames = new String[] { "Suported Files (*.tg,*.gp3,*.gp4)" };
        String[] filterExtensions = new String[] { "*.tg;*.gp3;*.gp4" };
        FileChooser chooser = new FileChooser(getEditor(),filterNames, filterExtensions,memory.getLastChooserPath(),memory.getFileName());
        final String fileName = chooser.show(SWT.OPEN | SWT.MULTI);
        if (fileName != null) {
            getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
            new Thread(new Runnable() {
                public void run() {
                    try {
                        getEditor().getSongManager().open(fileName);
                    } catch (FileNotFoundException e) {
                        showErrorMessage(fileName);
                        e.printStackTrace();
                    } catch (GPFormatException e) {
                        showErrorMessage(fileName);
                        e.printStackTrace();
                    } catch (IOException e) {
                        showErrorMessage(fileName);
                        e.printStackTrace();
                    }
                    
                    getEditor().notifyMemoryHelper(fileName);

                    new SyncThread(getEditor(), new Runnable() {
                        public void run() {
                            getEditor().resetDefaults();
                            redraw();
                            getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);
                        }
                    }).start();

                }
            }).start();

        }

        return true;
    }
    
    
    private void showErrorMessage(final String fileName){
        new SyncThread(getEditor(), new Runnable() {
            public void run() {
                getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);                
                String name = "Error Message";
                String message = "Cannot Open file: " + fileName;
                new AlertMessage(getEditor(),name,message,SWT.ICON_ERROR | SWT.OK).show();
                
            }
        }).start();        
        

    }

}