/*
 * Created on 18-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions;

import java.util.HashMap;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.caret.GoDownAction;
import org.herac.tuxguitar.gui.actions.caret.GoLeftAction;
import org.herac.tuxguitar.gui.actions.caret.GoRightAction;
import org.herac.tuxguitar.gui.actions.caret.GoUpAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTempoAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTimeSignatureAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.duration.DecrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.IncrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetEighthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetHalfDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetQuarterDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixteenthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixtyFourthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetThirtySecondDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetWholeDurationAction;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.actions.insert.CloseRepeatAction;
import org.herac.tuxguitar.gui.actions.insert.OpenRepeatAction;
import org.herac.tuxguitar.gui.actions.measure.AddMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.CopyMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoFirstMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoLastMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoNextMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoPreviousMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.PasteMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.RemoveMeasureAction;
import org.herac.tuxguitar.gui.actions.mouse.SelectComponentAction;
import org.herac.tuxguitar.gui.actions.note.ChangeNoteAction;
import org.herac.tuxguitar.gui.actions.note.ChangeTiedNoteAction;
import org.herac.tuxguitar.gui.actions.note.InsertNoteAction;
import org.herac.tuxguitar.gui.actions.note.RemoveNoteAction;
import org.herac.tuxguitar.gui.actions.player.PlaySongAction;
import org.herac.tuxguitar.gui.actions.player.StopSongAction;
import org.herac.tuxguitar.gui.actions.track.AddTrackAction;
import org.herac.tuxguitar.gui.actions.track.ChangeTunningTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoFirstTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoLastTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoNextTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoPreviousTrackAction;
import org.herac.tuxguitar.gui.actions.track.RemoveTrackAction;
import org.herac.tuxguitar.gui.actions.track.SelectInstrumentTrackAction;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ActionContainer {
    private HashMap actions;    
    private TablatureEditor tablatureEditor;
    private TypedEvent lastEvent;
    
    public ActionContainer(TablatureEditor tablatureEditor){
        this.tablatureEditor = tablatureEditor;
        this.actions = new HashMap();        
    }
    
    public void initActions(){                
        //file actions
        addAction(new NewFileAction(this.tablatureEditor));
        addAction(new OpenFileAction(this.tablatureEditor));
        addAction(new SaveFileAction(this.tablatureEditor));
        
        //composition actions
        addAction(new ChangeTimeSignatureAction(this.tablatureEditor));
        addAction(new ChangeTempoAction(this.tablatureEditor));
        
        //track actions
        addAction(new AddTrackAction(this.tablatureEditor));
        addAction(new RemoveTrackAction(this.tablatureEditor));
        addAction(new GoFirstTrackAction(this.tablatureEditor));
        addAction(new GoLastTrackAction(this.tablatureEditor));
        addAction(new GoNextTrackAction(this.tablatureEditor));
        addAction(new GoPreviousTrackAction(this.tablatureEditor));
        addAction(new SelectInstrumentTrackAction(this.tablatureEditor));
        addAction(new ChangeTunningTrackAction((this.tablatureEditor)));
        
        //measure actions
        addAction(new AddMeasureAction(this.tablatureEditor));
        addAction(new RemoveMeasureAction(this.tablatureEditor));
        addAction(new CopyMeasureAction(this.tablatureEditor));
        addAction(new PasteMeasureAction(this.tablatureEditor));
        addAction(new GoFirstMeasureAction(this.tablatureEditor));
        addAction(new GoLastMeasureAction(this.tablatureEditor));
        addAction(new GoNextMeasureAction(this.tablatureEditor));
        addAction(new GoPreviousMeasureAction(this.tablatureEditor));

        //note actions
        addAction(new ChangeNoteAction(this.tablatureEditor));
        addAction(new ChangeTiedNoteAction(this.tablatureEditor));
        addAction(new InsertNoteAction(this.tablatureEditor));
        addAction(new RemoveNoteAction(this.tablatureEditor));
        
        //duration actions
        addAction(new SetWholeDurationAction(this.tablatureEditor));
        addAction(new SetHalfDurationAction(this.tablatureEditor));
        addAction(new SetQuarterDurationAction(this.tablatureEditor));
        addAction(new SetEighthDurationAction(this.tablatureEditor));
        addAction(new SetSixteenthDurationAction(this.tablatureEditor));
        addAction(new SetThirtySecondDurationAction(this.tablatureEditor));
        addAction(new SetSixtyFourthDurationAction(this.tablatureEditor));
        addAction(new ChangeDottedDurationAction(this.tablatureEditor));
        addAction(new ChangeTupletoDurationAction(this.tablatureEditor));
        addAction(new IncrementDurationAction(this.tablatureEditor));
        addAction(new DecrementDurationAction(this.tablatureEditor));
        
        //insert actions
        addAction(new OpenRepeatAction(this.tablatureEditor));
        addAction(new CloseRepeatAction(this.tablatureEditor));         
        
        //player actions
        addAction(new PlaySongAction(this.tablatureEditor));
        addAction(new StopSongAction(this.tablatureEditor));        
        
        
        //caret actions
        addAction(new GoRightAction(this.tablatureEditor));
        addAction(new GoLeftAction(this.tablatureEditor));
        addAction(new GoUpAction(this.tablatureEditor));
        addAction(new GoDownAction(this.tablatureEditor));        
        
        //mouse actions
        addAction(new SelectComponentAction(this.tablatureEditor));
    }
    
    
    private void addAction(Action action){
        this.actions.put(action.getName(),action);
    }
 
    public Action getAction(String name){
        return (Action)this.actions.get(name);
    }    
    
    
    public TypedEvent getLastEvent() {
        return lastEvent;
    }
    
    public void setLastEvent(TypedEvent lastEvent) {
        this.lastEvent = lastEvent;
    }
}
