/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.midiplayer;

import java.util.Iterator;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongSequence {
    private Sequence sequence;
    private Song song;

    public SongSequence(Song song) {
        this.song = song;
    }

    public void createSongSecuence() {
        this.createSecuence();
    }

    public Sequence getSongSecuence() {
        return this.sequence;
    }

    private void createSecuence() {
        try {
            this.sequence = new Sequence(0.0f, 1);
            Iterator it = this.song.getTracks().iterator();
            int trackIdx = 0;
            while (trackIdx < this.song.getTracks().size()) {
                SongTrack songTrack = (SongTrack)this.song.getTracks().get(trackIdx);
                this.createTrack(songTrack, trackIdx == 0);
                ++trackIdx;
            }
            this.addTimeSignature(new TimeSignature(4, new Duration(4)), 0L, this.sequence.getTracks()[0]);
            this.addTempo(new Tempo(100), 0L, this.sequence.getTracks()[0]);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    private void createTrack(SongTrack songTrack, boolean firstTrack) {
        try {
            Track midiTrack = this.sequence.createTrack();
            this.createInstrument(midiTrack, songTrack.getChannel(), songTrack.getInstrument());
            long repeatStart = 1000L;
            boolean repeatOpen = true;
            long repeatEnd = 0L;
            long startMove = 0L;
            int repeatStartIndex = 0;
            int repeatNumber = 0;
            Measure prevMeasure = null;
            int measureIdx = 0;
            while (measureIdx < songTrack.getMeasures().size()) {
                Measure measure = (Measure)songTrack.getMeasures().get(measureIdx);
                if (firstTrack) {
                    this.makeMeasureStartMetaMessage(midiTrack, measureIdx, measure, startMove);
                }
                this.createNotes(midiTrack, songTrack, measure, measureIdx, startMove);
                this.addTimeSignature(measure, prevMeasure, startMove, midiTrack);
                this.addTempo(measure, prevMeasure, startMove, midiTrack);
                if (measure.isRepeatStart()) {
                    repeatStartIndex = measureIdx;
                    repeatStart = measure.getStart();
                    repeatOpen = true;
                }
                if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
                    if (repeatNumber < measure.getNumberOfRepetitions()) {
                        repeatEnd = measure.getStart() + measure.getLength();
                        startMove += repeatEnd - repeatStart;
                        measureIdx = repeatStartIndex - 1;
                        ++repeatNumber;
                    } else {
                        repeatStart = 0L;
                        repeatNumber = 0;
                        repeatEnd = 0L;
                        repeatOpen = false;
                    }
                }
                prevMeasure = measure;
                ++measureIdx;
            }
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    private void createNotes(Track midiTrack, SongTrack songTrack, Measure measure, int measureIdx, long startMove) {
        int noteIdx = 0;
        while (noteIdx < measure.getNotes().size()) {
            Note note = (Note)measure.getNotes().get(noteIdx);
            if (!note.isTiedNote()) {
                int key = note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                long start = note.getStart() + startMove;
                long duration = this.getRealNoteDuration(note, songTrack.getMeasures(), measureIdx, noteIdx);
                int velocity = note.getVelocity();
                this.createNote(midiTrack, key, start, duration, velocity, songTrack.getChannel());
            }
            ++noteIdx;
        }
    }

    private void createNote(Track track, int key, long start, long duration, int velocity, int channel) {
        try {
            ShortMessage messageOn = new ShortMessage();
            ShortMessage messageOff = new ShortMessage();
            messageOn.setMessage(144, channel, key, velocity);
            messageOff.setMessage(128, channel, key, velocity);
            track.add(new MidiEvent(messageOn, start));
            track.add(new MidiEvent(messageOff, start + duration));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    private void createInstrument(Track track, int channel, int instrument) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(192, channel, instrument, 0);
            track.add(new MidiEvent(message, 0L));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void addTimeSignature(Measure currMeasure, Measure prevMeasure, long startMove, Track track) throws InvalidMidiDataException {
        boolean addTimeSignature = false;
        if (prevMeasure == null) {
            addTimeSignature = true;
        } else {
            int currNumerator = currMeasure.getTimeSignature().getNumerator();
            int currValue = currMeasure.getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getTimeSignature().getDenominator().getValue();
            if (currNumerator != prevNumerator || currValue != prevValue) {
                addTimeSignature = true;
            }
        }
        if (addTimeSignature) {
            this.addTimeSignature(currMeasure.getTimeSignature(), currMeasure.getStart() + startMove, track);
        }
    }

    private void addTimeSignature(TimeSignature timeSignature, long tick, Track track) throws InvalidMidiDataException {
        MetaMessage metaMessage = new MetaMessage();
        byte[] data = new byte[4];
        data[0] = (byte)timeSignature.getNumerator();
        if (timeSignature.getDenominator().getValue() == 1) {
            data[1] = 0;
        } else if (timeSignature.getDenominator().getValue() == 2) {
            data[1] = 1;
        } else if (timeSignature.getDenominator().getValue() == 4) {
            data[1] = 2;
        } else if (timeSignature.getDenominator().getValue() == 8) {
            data[1] = 3;
        } else if (timeSignature.getDenominator().getValue() == 16) {
            data[1] = 4;
        } else if (timeSignature.getDenominator().getValue() == 32) {
            data[1] = 5;
        } else {
            throw new InvalidMidiDataException();
        }
        data[2] = (byte)(96 / timeSignature.getDenominator().getValue());
        data[3] = 8;
        metaMessage.setMessage(88, data, 4);
        MidiEvent midiEvent = new MidiEvent(metaMessage, tick);
        track.add(midiEvent);
    }

    private void addTempo(Measure currMeasure, Measure prevMeasure, long startMove, Track track) throws InvalidMidiDataException {
        boolean addTempo = false;
        if (prevMeasure == null) {
            addTempo = true;
        } else if (currMeasure.getTempo().getValue() != prevMeasure.getTempo().getValue()) {
            addTempo = true;
        }
        if (addTempo) {
            this.addTempo(currMeasure.getTempo(), currMeasure.getStart() + startMove, track);
        }
    }

    private void addTempo(Tempo tempo, long tick, Track track) throws InvalidMidiDataException {
        int usq = (int)tempo.getInMillis();
        MetaMessage metaMessage = new MetaMessage();
        byte[] data = new byte[]{(byte)(usq >> 16 & 0xFF), (byte)(usq >> 8 & 0xFF), (byte)(usq & 0xFF)};
        metaMessage.setMessage(81, data, 3);
        MidiEvent midiEvent = new MidiEvent(metaMessage, tick);
        track.add(midiEvent);
    }

    private long getRealNoteDuration(Note note, List measures, int measureIndex, int noteIndex) {
        long duration = note.getDuration().getTime();
        ++noteIndex;
        int mIdx = measureIndex;
        while (mIdx < measures.size()) {
            Measure measure = (Measure)measures.get(mIdx);
            int nIdx = noteIndex;
            while (nIdx < measure.getNotes().size()) {
                Note nextNote = (Note)measure.getNotes().get(nIdx);
                if (!nextNote.equals(note) && nextNote.getString() == note.getString()) {
                    if (nextNote.isTiedNote()) {
                        duration += nextNote.getDuration().getTime();
                    } else {
                        return duration;
                    }
                }
                ++nIdx;
            }
            noteIndex = 0;
            ++mIdx;
        }
        return duration;
    }

    public void makeMeasureStartMetaMessage(Track track, int index, Measure measure, long startMove) {
        MetaMessage metaMessage = new MetaMessage();
        String start = Long.toString(measure.getStart());
        byte[] data = start.getBytes();
        try {
            metaMessage.setMessage(1, data, data.length);
            MidiEvent event = new MidiEvent(metaMessage, measure.getStart() + startMove);
            track.add(event);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }
}

