/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class TGInputStream {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataInputStream dataInputStream;

    public TGInputStream(FileInputStream file) throws FileNotFoundException {
        this.dataInputStream = new DataInputStream(file);
    }

    public TGInputStream(String fileName) throws FileNotFoundException {
        this(new FileInputStream(new File(fileName)));
    }

    public Song read() {
        try {
            String version = this.readVersion();
            Song song = this.readSong();
            this.dataInputStream.close();
            return song;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readVersion() {
        String version = this.readString();
        return version;
    }

    private Song readSong() {
        String name = this.readString();
        int trackCount = this.readInt();
        ArrayList<SongTrack> tracks = new ArrayList<SongTrack>(trackCount);
        int i = 0;
        while (i < trackCount) {
            tracks.add(this.readTrack());
            ++i;
        }
        return new Song(name, tracks);
    }

    private SongTrack readTrack() {
        int channel = this.readInt();
        int instrument = this.readInt();
        int measureCount = this.readInt();
        ArrayList<Measure> measures = new ArrayList<Measure>(measureCount);
        int i = 0;
        while (i < measureCount) {
            measures.add(this.readMeasure());
            ++i;
        }
        int stringCount = this.readInt();
        ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>(stringCount);
        int i2 = 0;
        while (i2 < stringCount) {
            strings.add(this.readInstrumentString());
            ++i2;
        }
        return new SongTrack(channel, instrument, measures, strings);
    }

    private Measure readMeasure() {
        long start = this.readLong();
        int noteCount = this.readInt();
        ArrayList<Note> notes = new ArrayList<Note>(noteCount);
        int i = 0;
        while (i < noteCount) {
            notes.add(this.readNote());
            ++i;
        }
        int silenceCount = this.readInt();
        ArrayList<Silence> silences = new ArrayList<Silence>(silenceCount);
        int i2 = 0;
        while (i2 < silenceCount) {
            silences.add(this.readSilence());
            ++i2;
        }
        TimeSignature timeSignature = this.readTimeSignature();
        Tempo tempo = this.readTempo();
        boolean repeatStart = this.readBoolean();
        int numberOfRepetitions = this.readInt();
        return new Measure(start, notes, silences, timeSignature, tempo, repeatStart, numberOfRepetitions);
    }

    private Note readNote() {
        int value = this.readInt();
        long start = this.readLong();
        Duration duration = this.readDuration();
        int velocity = this.readInt();
        int string = this.readInt();
        boolean tiedNote = this.readBoolean();
        return new Note(value, start, duration, velocity, string, tiedNote);
    }

    private Silence readSilence() {
        long start = this.readLong();
        Duration duration = this.readDuration();
        return new Silence(start, duration);
    }

    private InstrumentString readInstrumentString() {
        int number = this.readInt();
        int value = this.readInt();
        return new InstrumentString(number, value);
    }

    private Tempo readTempo() {
        int value = this.readInt();
        return new Tempo(value);
    }

    private TimeSignature readTimeSignature() {
        int numerator = this.readInt();
        Duration denominator = this.readDuration();
        return new TimeSignature(numerator, denominator);
    }

    private Duration readDuration() {
        int value = this.readInt();
        boolean dotted = this.readBoolean();
        Tupleto tupleto = this.readTupleto();
        return new Duration(value, dotted, tupleto);
    }

    private Tupleto readTupleto() {
        int enters = this.readInt();
        int times = this.readInt();
        return new Tupleto(enters, times);
    }

    private int readInt() {
        try {
            return this.dataInputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private long readLong() {
        try {
            return this.dataInputStream.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private String readString() {
        try {
            int length = this.dataInputStream.read();
            char[] chars = new char[length];
            int i = 0;
            while (i < chars.length) {
                chars[i] = this.dataInputStream.readChar();
                ++i;
            }
            return String.copyValueOf(chars);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean readBoolean() {
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

