/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo;

import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.song.models.Song;

public class UndoableEdit {
    private static final int UNDO_ACTION = 1;
    private static final int REDO_ACTION = 2;
    private TablatureEditor tablatureEditor;
    private Song beforeEdit;
    private Song afterEdit;
    private int doAction;

    public UndoableEdit(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
        this.doAction = 1;
    }

    public void setBeforeEdit(Song beforeEdit) {
        this.beforeEdit = beforeEdit;
    }

    public void setAfterEdit(Song afterEdit) {
        this.afterEdit = afterEdit;
    }

    public void redo() throws CannotRedoException {
        if (this.canRedo()) {
            this.replace(this.afterEdit);
            this.doAction = 1;
        }
    }

    public void undo() throws CannotUndoException {
        if (this.canUndo()) {
            this.replace(this.beforeEdit);
            this.doAction = 2;
        }
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private void replace(Song song) {
        this.tablatureEditor.getSongManager().setSong(song);
        this.tablatureEditor.getTablature().updateTablature();
        this.tablatureEditor.getTablature().redraw();
    }
}

