/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureComponent;
import org.herac.tuxguitar.gui.tab.widgets.NoteCoords;
import org.herac.tuxguitar.gui.tab.widgets.SilenceCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.widgets.Tablature;
import org.herac.tuxguitar.gui.tab.widgets.TablatureUtil;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class MeasureCoords {
    public static final int DEFAULT_LEFT_SPAN = 15;
    public static final int DEFAULT_RIGHT_SPAN = 15;
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;
    public static final int DEFAULT_QUARTER_SPAN = 30;
    private Tablature tablature;
    private int measureId;
    private int posX;
    private int posY;
    private int lastFromX;
    private int lastFromY;
    private int width;
    private int height;
    private int quarterSpan;
    private long beatLength;
    private boolean paintTimeSignature;
    private boolean paintTempo;
    private List measureComponents;
    private Measure measure;
    private SongTrackCoords trackCoords;
    private SongManager songManager;
    private Caret caret;

    public MeasureCoords(int measureId, SongManager songManager, Tablature tablature, Measure measure, SongTrackCoords trackCoords) {
        this.measureId = measureId;
        this.measure = measure;
        this.trackCoords = trackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    public void create() {
        this.measureComponents.clear();
        this.beatLength = TablatureUtil.getBeatLength(this.getMeasure().getTimeSignature());
        this.autoCompleteSilences();
        this.calculateQuarterSpan();
    }

    public void update() {
        this.orderNotes();
        this.calculateTimeSignature();
        this.calculateTempo();
        this.calculateWidth();
        this.calculateHeight();
        this.calcuateComponents();
        this.updateComponents();
        this.updateCaret();
    }

    private void calculateQuarterSpan() {
        if (this.measure.getNotes().isEmpty() && this.measure.getSilences().isEmpty()) {
            this.quarterSpan = 30;
        } else {
            Duration minDuration = null;
            if (!this.measure.getNotes().isEmpty()) {
                Note minNote = null;
                int noteIdx = 0;
                while (noteIdx < this.measure.getNotes().size()) {
                    Note currentNote = (Note)this.measure.getNotes().get(noteIdx);
                    if (minNote == null || currentNote.getDuration().getTime() <= minNote.getDuration().getTime()) {
                        minNote = currentNote;
                    }
                    ++noteIdx;
                }
                minDuration = minNote.getDuration();
            }
            if (!this.measure.getSilences().isEmpty()) {
                Silence minSilence = null;
                int silenceIdx = 0;
                while (silenceIdx < this.measure.getSilences().size()) {
                    Silence currentSilence = (Silence)this.measure.getSilences().get(silenceIdx);
                    if (minSilence == null || currentSilence.getDuration().getTime() <= minSilence.getDuration().getTime()) {
                        minSilence = currentSilence;
                    }
                    ++silenceIdx;
                }
                if (minDuration == null || minSilence.getDuration().getTime() <= minDuration.getTime()) {
                    minDuration = minSilence.getDuration();
                }
            }
            this.quarterSpan = TablatureUtil.getSpanForQuarter(minDuration);
        }
    }

    private void calculateTimeSignature() {
        this.paintTimeSignature = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if (prevMeasure == null) {
            this.paintTimeSignature = true;
        } else {
            int thisNumerator = this.getMeasure().getTimeSignature().getNumerator();
            int thisValue = this.getMeasure().getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getMeasure().getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getMeasure().getTimeSignature().getDenominator().getValue();
            if (thisNumerator != prevNumerator || thisValue != prevValue) {
                this.paintTimeSignature = true;
            }
        }
    }

    private void calculateTempo() {
        this.paintTempo = false;
        MeasureCoords prevMeasure = this.trackCoords.getPrevMeasure(this);
        if (prevMeasure == null) {
            this.paintTempo = true;
        } else if (this.getMeasure().getTempo().getValue() != prevMeasure.getMeasure().getTempo().getValue()) {
            this.paintTempo = true;
        }
    }

    private void calcuateComponents() {
        this.measureComponents.clear();
        this.calculateComponentsCoords();
    }

    private void calculateComponentsCoords() {
        int posX = 0;
        int posY = 0;
        int noteIdx = 0;
        while (noteIdx < this.measure.getNotes().size()) {
            Note note = (Note)this.measure.getNotes().get(noteIdx);
            posY = note.getString() * 12;
            posX = TablatureUtil.getStartPosition(this.measure, note.getStart(), this.quarterSpan) + 10;
            this.measureComponents.add(new NoteCoords(this.trackCoords, this, note, posX + this.getTimeSignatureSpan(), posY));
            ++noteIdx;
        }
        int silenceIdx = 0;
        while (silenceIdx < this.measure.getSilences().size()) {
            Silence silence = (Silence)this.measure.getSilences().get(silenceIdx);
            posX = TablatureUtil.getStartPosition(this.measure, silence.getStart(), this.quarterSpan) + 5;
            this.measureComponents.add(new SilenceCoords(this.tablature, this, silence, posX + this.getTimeSignatureSpan(), 30));
            ++silenceIdx;
        }
    }

    private void autoCompleteSilences() {
        this.measureComponents.clear();
        int noteIdx = 0;
        while (noteIdx < this.measure.getNotes().size()) {
            this.measureComponents.add(new NoteCoords(this.trackCoords, this, (Note)this.measure.getNotes().get(noteIdx), 0, 0));
            ++noteIdx;
        }
        int silenceIdx = 0;
        while (silenceIdx < this.measure.getSilences().size()) {
            this.measureComponents.add(new SilenceCoords(this.tablature, this, (Silence)this.measure.getSilences().get(silenceIdx), 0, 0));
            ++silenceIdx;
        }
        long start = this.getMeasure().getStart();
        long end = 0L;
        long diff = 0L;
        MeasureComponent component = this.getFirstComponent();
        while (component != null) {
            end = component.getStart() + component.getDuration().getTime();
            if (component.getStart() > start && (diff = component.getStart() - start) > 0L) {
                this.createSilences(start, diff);
            }
            start = end;
            component = this.getNextComponent(component);
        }
        end = this.getMeasure().getStart() + this.getMeasure().getLength();
        diff = end - start;
        if (diff > 0L) {
            this.createSilences(start, diff);
        }
    }

    private void createSilences(long start, long length) {
        List durations = TablatureUtil.createDurations(length);
        Iterator it = durations.iterator();
        while (it.hasNext()) {
            Duration duration = (Duration)it.next();
            Silence silence = new Silence(start, duration);
            this.addSilence(silence);
            start += duration.getTime();
        }
    }

    private void updateComponents() {
        Iterator it = this.measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent)it.next();
            component.update();
        }
    }

    private void updateCaret() {
        if (this.caret != null && !this.measureComponents.contains(this.caret.getSelectedComponent())) {
            MeasureComponent component = this.getComponent(this.caret.getPosition());
            if (component == null) {
                component = this.getFirstComponent();
            }
            this.caret.moveTo(this.trackCoords, this, component);
        }
    }

    private void calculateWidth() {
        TimeSignature timeSignature = this.getMeasure().getTimeSignature();
        double quartersInSignature = 1.0 / (double)timeSignature.getDenominator().getValue() * 4.0 * (double)timeSignature.getNumerator();
        this.width = (int)((double)this.quarterSpan * quartersInSignature);
        this.width += this.getTimeSignatureSpan();
        this.width += 15;
        this.width += 15;
    }

    private void calculateHeight() {
        this.height = this.trackCoords.getTrack().getStrings().size() * 12;
    }

    private void orderNotes() {
        int i = 0;
        while (i < this.getMeasure().getNotes().size()) {
            Note minNote = null;
            int noteIdx = i;
            while (noteIdx < this.getMeasure().getNotes().size()) {
                Note note = (Note)this.getMeasure().getNotes().get(noteIdx);
                if (minNote == null || note.getStart() < minNote.getStart()) {
                    minNote = note;
                }
                ++noteIdx;
            }
            this.getMeasure().getNotes().remove(minNote);
            this.getMeasure().getNotes().add(i, minNote);
            ++i;
        }
    }

    private void orderComponents() {
        int i = 0;
        while (i < this.measureComponents.size()) {
            MeasureComponent minComponent = null;
            int j = i;
            while (j < this.measureComponents.size()) {
                MeasureComponent component = (MeasureComponent)this.measureComponents.get(j);
                if (minComponent == null || component.getStart() < minComponent.getStart()) {
                    minComponent = component;
                }
                ++j;
            }
            this.measureComponents.remove(minComponent);
            this.measureComponents.add(i, minComponent);
            ++i;
        }
    }

    public void paintMeasure(GC gc, int fromX, int fromY, Rectangle clientArea) {
        this.paintTempo(gc, fromX, fromY);
        this.paintTimeSignature(gc, fromX, fromY);
        this.paintComponents(gc, fromX, fromY, clientArea);
        this.paintDivisions(gc, fromX, fromY);
        this.paintCaret(gc, fromX, fromY);
        this.lastFromX = fromX;
        this.lastFromY = fromY;
    }

    public void paintComponents(GC gc, int fromX, int fromY, Rectangle clientArea) {
        if (this.isPlaying()) {
            gc.setForeground(this.tablature.getDisplay().getSystemColor(3));
        }
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent component = (MeasureComponent)this.measureComponents.get(noteIdx);
            component.paint(gc, fromX + 15, fromY);
            ++noteIdx;
        }
        if (this.isPlaying()) {
            gc.setForeground(new Color((Device)this.tablature.getDisplay(), 0, 0, 0));
        }
    }

    public void paintCaret(GC gc, int fromX, int fromY) {
        if (this.hasCaret()) {
            this.caret.paintCaret(gc, fromX + 15 + this.getTimeSignatureSpan(), fromY);
        }
    }

    private void paintDivisions(GC gc, int fromX, int fromY) {
        int y1 = fromY + 12;
        int y2 = fromY + this.trackCoords.getTrack().getStrings().size() * 12;
        if (this.measure.isRepeatStart()) {
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);
            gc.drawOval(fromX + 7, y1 + (y2 - y1) / 2 - 7, 1, 2);
            gc.drawOval(fromX + 7, y1 + (y2 - y1) / 2 + 7, 1, 2);
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);
        } else if (this.isFirstMeasure()) {
            gc.setLineWidth(3);
            gc.drawLine(fromX, y1, fromX, y2);
            gc.setLineWidth(1);
            gc.drawLine(fromX + 3, y1, fromX + 3, y2);
        } else {
            gc.drawLine(fromX, y1, fromX, y2);
        }
        if (this.measure.getNumberOfRepetitions() > 0) {
            gc.setLineWidth(3);
            gc.drawLine(fromX + this.getWidth(), y1, fromX + this.getWidth(), y2);
            gc.drawOval(fromX + this.getWidth() - 8, y1 + (y2 - y1) / 2 - 7, 2, 2);
            gc.drawOval(fromX + this.getWidth() - 8, y1 + (y2 - y1) / 2 + 7, 2, 2);
            gc.setLineWidth(1);
            gc.drawLine(fromX + this.getWidth() - 3, y1, fromX + this.getWidth() - 3, y2);
            gc.drawString("x" + Integer.toString(this.measure.getNumberOfRepetitions()), fromX + this.getWidth() - 10, fromY - 5);
        } else if (this.isLastMeasure()) {
            gc.setLineWidth(3);
            gc.drawLine(fromX + this.getWidth(), y1, fromX + this.getWidth(), y2);
            gc.setLineWidth(1);
            gc.drawLine(fromX + this.getWidth() - 3, y1, fromX + this.getWidth() - 3, y2);
        } else {
            gc.drawLine(fromX + this.getWidth(), y1, fromX + this.getWidth(), y2);
        }
    }

    private void paintTimeSignature(GC gc, int fromX, int fromY) {
        if (this.paintTimeSignature) {
            Font currFont = gc.getFont();
            gc.setFont(new Font((Device)this.tablature.getDisplay(), new FontData("Arial", 14, 1)));
            int center = this.getHeight() / 2;
            int x = fromX + 15 + 10;
            int y1 = fromY + (center - 12);
            int y2 = fromY + (center + 5);
            gc.drawString(Integer.toString(this.getMeasure().getTimeSignature().getNumerator()), x, y1);
            gc.drawString(Integer.toString(this.getMeasure().getTimeSignature().getDenominator().getValue()), x, y2);
            gc.setFont(currFont);
        }
    }

    private void paintTempo(GC gc, int fromX, int fromY) {
        if (this.paintTempo) {
            int x = fromX;
            int y = fromY - 10;
            String tempo = "Tempo: " + this.getMeasure().getTempo().getValue();
            gc.drawString(tempo, x, y);
        }
    }

    private boolean isPlaying() {
        long playerTickPosition;
        return this.songManager.getPlayer().isRunning() && (playerTickPosition = this.songManager.getPlayer().getTickPosition()) >= this.getMeasure().getStart() && playerTickPosition < this.getMeasure().getStart() + this.getMeasure().getLength();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTimeSignatureSpan() {
        int span = 0;
        if (this.paintTimeSignature) {
            span = 40;
        }
        return span;
    }

    public MeasureComponent getPreviousComponent(MeasureComponent component) {
        MeasureComponent prevComponent = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (currComponent.getStart() < component.getStart()) {
                if (prevComponent == null) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() > prevComponent.getStart()) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() == prevComponent.getStart() && currComponent.getDuration().getTime() <= prevComponent.getDuration().getTime()) {
                    prevComponent = currComponent;
                }
            }
            ++noteIdx;
        }
        return prevComponent;
    }

    public MeasureComponent getNextComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart() && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            ++noteIdx;
        }
        return nextComponent;
    }

    public MeasureComponent getFirstComponent() {
        MeasureComponent firstComponent = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (firstComponent == null || currComponent.getStart() < firstComponent.getStart()) {
                firstComponent = currComponent;
            }
            ++noteIdx;
        }
        return firstComponent;
    }

    public MeasureComponent getLastComponent() {
        MeasureComponent lastComponent = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (lastComponent == null || lastComponent.getStart() < currComponent.getStart()) {
                lastComponent = currComponent;
            }
            ++noteIdx;
        }
        return lastComponent;
    }

    public MeasureComponent getComponent(long start) {
        MeasureComponent component = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (currComponent.getStart() == start) {
                component = currComponent;
                break;
            }
            ++noteIdx;
        }
        return component;
    }

    public List getComponents(long start) {
        ArrayList<MeasureComponent> components = new ArrayList<MeasureComponent>();
        Iterator it = this.measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() != start) continue;
            components.add(currComponent);
        }
        return components;
    }

    public MeasureComponent getComponent(long start, int string) {
        MeasureComponent component = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            NoteCoords note;
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (currComponent instanceof NoteCoords && (note = (NoteCoords)currComponent).getStart() == start && note.getNote().getString() == string) {
                component = currComponent;
                break;
            }
            ++noteIdx;
        }
        return component;
    }

    public List getComponentsBeforeEnd(long fromStart) {
        ArrayList<MeasureComponent> components = new ArrayList<MeasureComponent>();
        Iterator it = this.measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() < fromStart) continue;
            components.add(currComponent);
        }
        return components;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (currComponent instanceof NoteCoords && currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart() && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            ++noteIdx;
        }
        return nextComponent;
    }

    public MeasureComponent getNextSilenceComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        int noteIdx = 0;
        while (noteIdx < this.measureComponents.size()) {
            MeasureComponent currComponent = (MeasureComponent)this.measureComponents.get(noteIdx);
            if (currComponent instanceof SilenceCoords && currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart() && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            ++noteIdx;
        }
        return nextComponent;
    }

    public MeasureComponent getComponentAt(int x) {
        MeasureComponent component = null;
        Iterator it = this.measureComponents.iterator();
        while (it.hasNext()) {
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (component == null) {
                component = currComponent;
                continue;
            }
            int distanceX = Math.abs(x - (component.getPosX() + this.lastFromX + 15));
            int currDistanceX = Math.abs(x - (currComponent.getPosX() + this.lastFromX + 15));
            if (currDistanceX >= distanceX) continue;
            component = currComponent;
        }
        return component;
    }

    public InstrumentString getStringAt(int y) {
        InstrumentString string = null;
        int minorDistance = 0;
        Iterator it = this.trackCoords.getTrack().getStrings().iterator();
        while (it.hasNext()) {
            InstrumentString currString = (InstrumentString)it.next();
            int distanceX = Math.abs(y - (currString.getNumber() * 12 + this.lastFromY));
            if (string != null && distanceX >= minorDistance) continue;
            string = currString;
            minorDistance = distanceX;
        }
        return string;
    }

    public void addComponent(MeasureComponent component) {
        this.measureComponents.add(component);
    }

    public void removeComponent(MeasureComponent component) {
        this.measureComponents.remove(component);
    }

    public boolean hasComponent(MeasureComponent component) {
        return this.measureComponents.contains(component);
    }

    public void removeComponentsAt(long start, int string, boolean addSilence) {
        List components = this.getComponents(start);
        Iterator it = components.iterator();
        while (it.hasNext()) {
            NoteCoords noteComp;
            MeasureComponent component = (MeasureComponent)it.next();
            if (component instanceof SilenceCoords) {
                SilenceCoords sileceComp = (SilenceCoords)component;
                this.removeSilence(sileceComp.getSilence());
                continue;
            }
            if (!(component instanceof NoteCoords) || (noteComp = (NoteCoords)component).getNote().getString() != string) continue;
            this.removeNote(noteComp.getNote());
            if (!addSilence || components.size() != 1) continue;
            this.addSilence(new Silence(noteComp.getStart(), (Duration)noteComp.getDuration().clone()));
        }
    }

    public void removeAllComponentsAt(long start) {
        List components = this.getComponents(start);
        Iterator it = components.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent)it.next();
            if (component instanceof SilenceCoords) {
                SilenceCoords sileceComp = (SilenceCoords)component;
                this.removeSilence(sileceComp.getSilence());
                continue;
            }
            if (!(component instanceof NoteCoords)) continue;
            NoteCoords noteComp = (NoteCoords)component;
            this.removeNote(noteComp.getNote());
        }
    }

    public void addNote(Note note) {
        int posX = TablatureUtil.getStartPosition(this.measure, note.getStart(), this.quarterSpan) + 5;
        NoteCoords noteComponent = new NoteCoords(this.trackCoords, this, note, posX, 30);
        if (this.canInsert(noteComponent, true, false)) {
            this.removeComponentsAt(note.getStart(), note.getString(), false);
            this.getMeasure().addNote(note);
            this.measureComponents.add(noteComponent);
            this.tryChangeSilenceAfter(noteComponent);
        }
    }

    public void tryChangeSilenceAfter(MeasureComponent component) {
        this.autoCompleteSilences();
        MeasureComponent nextComponent = this.getNextComponent(component);
        long componentEnd = component.getStart() + component.getDuration().getTime();
        if (nextComponent instanceof SilenceCoords && componentEnd <= this.getMeasure().getLength()) {
            this.moveComponent(nextComponent, this.getRealStart(componentEnd) - this.getRealStart(nextComponent.getStart()));
            this.changeDuration(nextComponent, (Duration)component.getDuration().clone());
        }
    }

    public void removeNote(Note note) {
        this.getMeasure().removeNote(note);
    }

    public void changeTieNote(long start, int string) {
        MeasureComponent component = this.getComponent(start, string);
        if (component instanceof NoteCoords) {
            NoteCoords note = (NoteCoords)component;
            note.getNote().setTiedNote(!note.getNote().isTiedNote());
        }
    }

    public void addSilence(Silence silence) {
        int posX = TablatureUtil.getStartPosition(this.measure, silence.getStart(), this.quarterSpan) + 5;
        SilenceCoords silenceComponent = new SilenceCoords(this.tablature, this, silence, posX, 30);
        if (this.canInsert(silenceComponent, true, false)) {
            this.removeAllComponentsAt(silence.getStart());
            this.getMeasure().addSilence(silence);
            this.measureComponents.add(silenceComponent);
        }
    }

    public void removeSilence(Silence silence) {
        this.removeSilence(silence, false);
    }

    public void removeSilence(Silence silence, boolean moveNextComponents) {
        MeasureComponent component = this.getComponent(silence.getStart());
        MeasureComponent nextComponent = this.getNextComponent(component);
        this.getMeasure().removeSilence(silence);
        if (moveNextComponents) {
            long start = silence.getStart();
            long length = silence.getDuration().getTime();
            if (nextComponent != null) {
                length = nextComponent.getStart() - start;
            }
            this.moveComponents(start + length, -length);
        }
    }

    public void changeDuration(long start, Duration duration) {
        List components = this.getComponents(start);
        Iterator it = components.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent)it.next();
            this.changeDuration(component, duration);
        }
    }

    public void changeDuration(MeasureComponent component, Duration duration) {
        Duration oldDuration = (Duration)component.getDuration().clone();
        component.setDuration((Duration)duration.clone());
        if (this.canInsert(component, true, true)) {
            this.tryChangeSilenceAfter(component);
        } else {
            component.setDuration(oldDuration);
        }
    }

    public boolean moveComponents(long start, long theMove) {
        long measureStart = this.getMeasure().getStart();
        long measureLength = this.getMeasure().getLength();
        List components = this.getComponentsBeforeEnd(start);
        this.moveComponents(components, theMove);
        MeasureComponent first = this.getFirstComponent();
        while (first instanceof SilenceCoords) {
            this.removeSilence(((SilenceCoords)first).getSilence());
            first = this.getNextComponent(first);
        }
        MeasureComponent last = this.getLastComponent();
        while (last instanceof SilenceCoords) {
            this.removeSilence(((SilenceCoords)last).getSilence());
            last = this.getPreviousComponent(last);
        }
        if (first != null && last != null && (first.getStart() < measureStart || last.getStart() + last.getDuration().getTime() > measureStart + measureLength)) {
            this.moveComponents(components, -theMove);
            return false;
        }
        return true;
    }

    public void moveAllComponents(long theMove) {
        this.moveComponents(this.measureComponents, theMove);
    }

    private void moveComponents(List components, long theMove) {
        Iterator it = components.iterator();
        while (it.hasNext()) {
            MeasureComponent component = (MeasureComponent)it.next();
            this.moveComponent(component, theMove);
        }
    }

    private void moveComponent(MeasureComponent component, long theMove) {
        long componentStart = component.getStart();
        component.setStart(componentStart + theMove);
    }

    public boolean isEmpty(long start) {
        return this.getComponents(start).isEmpty();
    }

    public boolean canInsert(MeasureComponent component, boolean removeSilences, boolean tryMove) {
        boolean canInsert = true;
        this.orderComponents();
        MeasureComponent nextComponent = this.getNextComponent(component);
        long componentEnd = component.getStart() + component.getDuration().getTime();
        if (nextComponent == null) {
            if (componentEnd > this.getMeasure().getStart() + this.getMeasure().getLength()) {
                canInsert = false;
            }
        } else if (componentEnd > nextComponent.getStart()) {
            canInsert = false;
        }
        if (removeSilences && !canInsert && nextComponent instanceof SilenceCoords) {
            long nextComponentEnd = 0L;
            ArrayList<MeasureComponent> nextSilences = new ArrayList<MeasureComponent>();
            while (nextComponent instanceof SilenceCoords) {
                nextSilences.add(nextComponent);
                nextComponentEnd = nextComponent.getStart() + nextComponent.getDuration().getTime();
                nextComponent = this.getNextComponent(nextComponent);
            }
            if (nextComponent == null) {
                nextComponentEnd = this.getMeasure().getStart() + this.getMeasure().getLength();
            } else if (nextComponent instanceof NoteCoords) {
                nextComponentEnd = nextComponent.getStart();
            }
            if (componentEnd <= nextComponentEnd) {
                while (!nextSilences.isEmpty()) {
                    SilenceCoords currSilence = (SilenceCoords)nextSilences.get(0);
                    this.getMeasure().removeSilence(currSilence.getSilence());
                    nextSilences.remove(currSilence);
                }
                canInsert = true;
            }
        }
        if (!canInsert && removeSilences && tryMove && (nextComponent = this.getNextComponent(component)) != null) {
            long requiredLength = component.getDuration().getTime() - (nextComponent.getStart() - component.getStart());
            long nextSilenceLength = 0L;
            ArrayList<MeasureComponent> nextSilences = new ArrayList<MeasureComponent>();
            MeasureComponent nextSilence = this.getNextSilenceComponent(component);
            while (nextSilence instanceof SilenceCoords) {
                nextSilences.add(nextSilence);
                nextSilenceLength += nextSilence.getDuration().getTime();
                nextSilence = this.getNextSilenceComponent(nextSilence);
            }
            if (requiredLength <= nextSilenceLength) {
                List components = this.getComponentsBeforeEnd(nextComponent.getStart());
                while (!components.isEmpty()) {
                    MeasureComponent currComponent = (MeasureComponent)components.get(0);
                    if (currComponent instanceof SilenceCoords) {
                        SilenceCoords currSilence = (SilenceCoords)currComponent;
                        requiredLength -= currSilence.getDuration().getTime();
                        this.getMeasure().removeSilence(currSilence.getSilence());
                    } else if (requiredLength > 0L) {
                        this.moveComponent(currComponent, requiredLength);
                    }
                    components.remove(0);
                }
                canInsert = true;
            }
        }
        return canInsert;
    }

    public long getBeatLength() {
        return this.beatLength;
    }

    public long getRealStart(long currStart) {
        boolean startBeat;
        long start = currStart;
        long beatLength = this.getBeatLength();
        boolean bl = startBeat = start % beatLength == 0L;
        if (!startBeat) {
            Duration minDuration = new Duration(64, false, new Tupleto(3, 2));
            int i = 0;
            while ((long)i < minDuration.getTime()) {
                boolean bl2 = startBeat = ++start % beatLength == 0L;
                if (startBeat) break;
                ++i;
            }
            if (!startBeat) {
                start = currStart;
            }
        }
        return start;
    }

    public boolean areInSameBeat(MeasureComponent arg0, MeasureComponent arg1) {
        long measureEnd = this.measure.getStart() + this.getMeasure().getLength();
        long beatLength = this.getBeatLength();
        long start1 = this.getRealStart(arg0.getStart());
        long start2 = this.getRealStart(arg1.getStart());
        long currStart = this.measure.getStart();
        boolean finish = false;
        while (!finish) {
            if (start1 >= currStart && start1 < currStart + beatLength && start2 >= currStart && start2 < currStart + beatLength) {
                return true;
            }
            if ((currStart += beatLength) <= measureEnd) continue;
            finish = true;
        }
        return false;
    }

    public void removeNotesAfterString(int string) {
        Iterator it = this.measureComponents.iterator();
        while (it.hasNext()) {
            NoteCoords note;
            MeasureComponent component = (MeasureComponent)it.next();
            if (!(component instanceof NoteCoords) || (note = (NoteCoords)component).getNote().getString() <= string) continue;
            this.removeNote(note.getNote());
        }
    }

    public boolean isFirstMeasure() {
        return this.measureId == 0;
    }

    public boolean isLastMeasure() {
        return this.trackCoords.getTrack().getMeasures().size() == this.measureId + 1;
    }

    public boolean hasCaret() {
        return this.caret != null;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        this.caret = caret;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getLastFromX() {
        return this.lastFromX;
    }

    public int getLastFromY() {
        return this.lastFromY;
    }

    public void setQuarterSpan(int quarterSpan) {
        this.quarterSpan = quarterSpan;
    }

    public int getQuarterSpan() {
        return this.quarterSpan;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public int getMeasureId() {
        return this.measureId;
    }

    public void setMeasureId(int measureId) {
        this.measureId = measureId;
    }
}

