/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class SelectInstrumentTrackAction
extends Action {
    public static final String NAME = "SELECT_INSTRUMENT_TRACK";
    private Instrument[] instruments;

    public SelectInstrumentTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measure = this.getEditor().getTablature().getCaret().getMeasureCoords();
        SongTrack track = this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack();
        if (measure != null) {
            final Shell dialog = new Shell(shell, 67680);
            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            dialog.setLayout((Layout)layout);
            Label instrumentLabel = new Label((Composite)dialog, 0);
            instrumentLabel.setText("Instrument:");
            final Combo instrumentCombo = new Combo((Composite)dialog, 0);
            Instrument[] instruments = this.getInstruments();
            int count = instruments.length;
            if (count > 128) {
                count = 128;
            }
            int i = 0;
            while (i < count) {
                instruments[i].getName();
                instrumentCombo.add(instruments[i].getName());
                ++i;
            }
            instrumentCombo.setText(instruments[track.getInstrument()].getName());
            instrumentCombo.setEnabled(!track.isPercusionTrack());
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            final Button percusion = new Button((Composite)dialog, 32);
            percusion.setText("Percusion Track");
            percusion.setLayoutData((Object)gridData);
            percusion.setSelection(track.isPercusionTrack());
            percusion.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    instrumentCombo.setEnabled(!percusion.getSelection());
                }
            });
            Button buttonOK = new Button((Composite)dialog, 8);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData((Object)new GridData(128));
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    SelectInstrumentTrackAction.this.setInstrument(instrumentCombo.getSelectionIndex(), percusion.getSelection());
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button((Composite)dialog, 8);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.pack();
            dialog.open();
            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    private Instrument[] getInstruments() {
        if (this.instruments == null) {
            this.instruments = this.loadInstruments();
        }
        return this.instruments;
    }

    private Instrument[] loadInstruments() {
        Instrument[] instruments = null;
        try {
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            Soundbank sb = synthesizer.getDefaultSoundbank();
            if (sb != null) {
                instruments = sb.getInstruments();
            }
            synthesizer.close();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        return instruments;
    }

    private void setInstrument(int instrument, boolean percusion) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongTrack track = caret.getSongTrackCoords().getTrack();
        if (percusion) {
            track.setChannel(this.getEditor().getSongManager().getFreeChannel(instrument, percusion));
            track.setInstrument(instrument);
            track.setStrings(SongManager.createPercusionStrings());
        } else {
            if (track.isPercusionTrack()) {
                track.setStrings(SongManager.createDefaultInstrumentStrings());
            }
            track.setChannel(this.getEditor().getSongManager().getFreeChannel(instrument, percusion));
            track.setInstrument(instrument);
        }
    }
}

