/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;

public class CloseRepeatAction
extends Action {
    public static final String NAME = "CLOSE_REPEAT";

    public CloseRepeatAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        MeasureCoords measureCoords = this.getEditor().getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.getEditor().getTablature().getCaret().getSongCoords();
        this.showCloseRepeatDialog(this.getEditor().getTablature().getShell(), measureCoords, songCoords);
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        this.redraw();
    }

    public void showCloseRepeatDialog(Shell shell, final MeasureCoords measureCoords, final SongCoords songCoords) {
        if (measureCoords != null) {
            final Shell dialog = new Shell(shell, 67680);
            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 20;
            layout.horizontalSpacing = 10;
            dialog.setLayout((Layout)layout);
            int currentNumberOfRepetitions = measureCoords.getMeasure().getNumberOfRepetitions();
            if (currentNumberOfRepetitions < 1) {
                currentNumberOfRepetitions = 1;
            }
            Label numberOfRepetitionsLabel = new Label((Composite)dialog, 0);
            numberOfRepetitionsLabel.setText("Number of Repetitions:");
            final Text numberOfRepetitions = new Text((Composite)dialog, 2048);
            numberOfRepetitions.setLayoutData((Object)new GridData(50, 10));
            numberOfRepetitions.setText(Integer.toString(currentNumberOfRepetitions));
            Button buttonOK = new Button((Composite)dialog, 8);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData((Object)new GridData(128));
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    CloseRepeatAction.this.closeRepeat(measureCoords, songCoords, Integer.parseInt(numberOfRepetitions.getText()));
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button((Composite)dialog, 8);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.pack();
            dialog.open();
            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    private void closeRepeat(MeasureCoords measureCoords, SongCoords songCoords, int numberOfRepetitions) {
        numberOfRepetitions = Math.abs(numberOfRepetitions);
        songCoords.changeCloseRepeat(measureCoords.getMeasure().getStart(), numberOfRepetitions);
        this.updateTablature();
    }
}

