/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.song.models.Tempo;

public class ChangeTempoAction
extends Action {
    public static final String NAME = "CHANGE_TEMPO";

    public ChangeTempoAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measure = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, 67680);
            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 20;
            layout.horizontalSpacing = 10;
            dialog.setLayout((Layout)layout);
            Tempo currentTempo = measure.getMeasure().getTempo();
            Label tempoLabel = new Label((Composite)dialog, 0);
            tempoLabel.setText("Tempo:");
            final Text tempo = new Text((Composite)dialog, 2048);
            tempo.setLayoutData((Object)new GridData(50, 10));
            tempo.setText(Integer.toString(currentTempo.getValue()));
            Button buttonOK = new Button((Composite)dialog, 8);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData((Object)new GridData(128));
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    int tempoValue = Integer.parseInt(tempo.getText());
                    Tempo tempo2 = new Tempo(tempoValue);
                    ChangeTempoAction.this.setTempo(tempo2);
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button((Composite)dialog, 8);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.pack();
            dialog.open();
            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    private void setTempo(Tempo tempo) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        songCoords.changeTempo(measure.getMeasure().getStart(), tempo, true);
        this.updateTablature();
        caret.update(caret.getMeasureCoords().getMeasure());
        this.redraw();
    }
}

