/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int clientHandle() {
        int index = OS.gtk_notebook_get_current_page(this.handle);
        if (index != -1 && this.items[index] != null) {
            return this.items[index].pageHandle;
        }
        return this.handle;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSize(wHint, hHint, changed);
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        boolean scrollable = OS.gtk_notebook_get_scrollable(this.handle);
        OS.gtk_notebook_set_scrollable(this.handle, false);
        Point notebookSize = this.computeNativeSize(this.handle, wHint, hHint, changed);
        OS.gtk_notebook_set_scrollable(this.handle, scrollable);
        size.x = Math.max(notebookSize.x, size.x);
        size.y = Math.max(notebookSize.y, size.y);
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        this.forceResize();
        int clientHandle = this.clientHandle();
        int clientX = OS.GTK_WIDGET_X(clientHandle);
        int clientY = OS.GTK_WIDGET_Y(clientHandle);
        x -= clientX;
        y -= clientY;
        width += clientX + clientX;
        if ((this.style & 0x400) != 0) {
            int parentHeight = OS.GTK_WIDGET_HEIGHT(this.handle);
            int clientHeight = OS.GTK_WIDGET_HEIGHT(clientHandle);
            height += parentHeight - clientHeight;
        } else {
            height += clientX + clientY;
        }
        return new Rectangle(x, y, width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_notebook_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_notebook_set_scrollable(this.handle, true);
        OS.gtk_notebook_set_show_tabs(this.handle, true);
        if ((this.style & 0x400) != 0) {
            OS.gtk_notebook_set_tab_pos(this.handle, 3);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TabItem[4];
    }

    void createItem(TabItem item, int index) {
        int imageHandle;
        int labelHandle;
        int boxHandle;
        int list = OS.gtk_container_get_children(this.handle);
        int itemCount = 0;
        if (list != 0) {
            itemCount = OS.g_list_length(list);
            OS.g_list_free(list);
        }
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        if (itemCount == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if ((boxHandle = OS.gtk_hbox_new(false, 0)) == 0) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add(boxHandle, imageHandle);
        OS.gtk_container_add(boxHandle, labelHandle);
        int pageHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (pageHandle == 0) {
            this.error(2);
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 42);
        OS.gtk_notebook_insert_page(this.handle, pageHandle, boxHandle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 42);
        OS.gtk_widget_show(boxHandle);
        OS.gtk_widget_show(labelHandle);
        OS.gtk_widget_show(pageHandle);
        item.state |= 8;
        item.handle = boxHandle;
        item.labelHandle = labelHandle;
        item.imageHandle = imageHandle;
        item.pageHandle = pageHandle;
        System.arraycopy(this.items, index, this.items, index + 1, itemCount++ - index);
        this.items[index] = item;
        if ((this.state & 0x2000) != 0) {
            item.setForegroundColor(this.getForegroundColor());
        }
        if ((this.state & 0x8000) != 0) {
            item.setFontDescription(this.getFontDescription());
        }
        if (itemCount == 1) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 42);
            OS.gtk_notebook_set_current_page(this.handle, 0);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 42);
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void destroyItem(TabItem item) {
        int newIndex;
        int index = 0;
        int itemCount = this.getItemCount();
        while (index < itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == itemCount) {
            this.error(15);
        }
        int oldIndex = OS.gtk_notebook_get_current_page(this.handle);
        item.deregister();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 42);
        OS.gtk_notebook_remove_page(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 42);
        System.arraycopy(this.items, index + 1, this.items, index, --itemCount - index);
        this.items[itemCount] = null;
        item.labelHandle = 0;
        item.imageHandle = 0;
        item.pageHandle = 0;
        item.handle = 0;
        if (index == oldIndex && (newIndex = OS.gtk_notebook_get_current_page(this.handle)) != -1) {
            Control control = this.items[newIndex].getControl();
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            Event event = new Event();
            event.item = this.items[newIndex];
            this.sendEvent(13, event);
        }
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public TabItem getItem(int index) {
        int list;
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        if ((list = OS.gtk_container_get_children(this.handle)) == 0) {
            this.error(8);
        }
        int itemCount = OS.g_list_length(list);
        OS.g_list_free(list);
        if (index < 0 || index >= itemCount) {
            this.error(8);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            return 0;
        }
        int itemCount = OS.g_list_length(list);
        OS.g_list_free(list);
        return itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = OS.gtk_notebook_get_current_page(this.handle);
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_notebook_get_current_page(this.handle);
    }

    int gtk_focus(int widget, int directionType) {
        return 0;
    }

    int gtk_switch_page(int widget, int page, int page_num) {
        TabItem item;
        Control control;
        Control control2;
        int index = OS.gtk_notebook_get_current_page(this.handle);
        if (index != -1 && (control2 = this.items[index].getControl()) != null && !control2.isDisposed()) {
            control2.setVisible(false);
        }
        if ((control = (item = this.items[page_num]).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect(this.handle, OS.switch_page, this.display.windowProc4, 42);
    }

    public int indexOf(TabItem item) {
        int list;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if ((list = OS.gtk_container_get_children(this.handle)) == 0) {
            return -1;
        }
        int count = OS.g_list_length(list);
        OS.g_list_free(list);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = 0;
            int list = OS.gtk_container_get_children(this.handle);
            if (list != 0) {
                count = OS.g_list_length(list);
                OS.g_list_free(list);
            }
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    boolean mnemonicHit(char key) {
        int itemCount = this.getItemCount();
        int selection = this.getSelectionIndex();
        int i = 0;
        while (i < itemCount) {
            int labelHandle;
            if (i != selection && (labelHandle = this.items[i].labelHandle) != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int itemCount = this.getItemCount();
        int selection = this.getSelectionIndex();
        int i = 0;
        while (i < itemCount) {
            int labelHandle;
            if (i != selection && (labelHandle = this.items[i].labelHandle) != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void releaseWidget() {
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int index;
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0 && (index = this.getSelectionIndex()) != -1) {
            TabItem item = this.items[index];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return result;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setFontDescription(font);
            }
            ++i;
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setForegroundColor(color);
            }
            ++i;
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        if (index < 0) {
            return;
        }
        int oldIndex = OS.gtk_notebook_get_current_page(this.handle);
        if (oldIndex != -1) {
            TabItem item = this.items[oldIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 42);
        OS.gtk_notebook_set_current_page(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 42);
        int newIndex = OS.gtk_notebook_get_current_page(this.handle);
        if (newIndex != -1) {
            TabItem item = this.items[newIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    boolean traversePage(boolean next) {
        OS.g_signal_emit_by_name(this.handle, OS.change_current_page, next ? 1 : -1);
        return true;
    }
}

