/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class GridViewer
extends NavigableTableViewer
implements IMenuListener {
    protected QueryStatement currentStatement;
    protected TableColumn c1;
    protected int totalRdbColumn;
    protected ColumnNameComboBoxCellEditor columnComboBoxCellEditor;
    protected Table table;
    protected SQLDomainModel domainModel;
    boolean isFillingCombo = false;

    public GridViewer(SQLDomainModel domainModel, Composite parent) {
        super(new Table(parent, 67586));
        this.domainModel = domainModel;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_DEFAULT_COLUMN);
        this.columnComboBoxCellEditor = new ColumnNameComboBoxCellEditor((Composite)this.table);
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public ComboBoxCellEditor getColumnComboBoxCellEditor() {
        return this.columnComboBoxCellEditor;
    }

    public int getTotalRdbColumn() {
        return this.totalRdbColumn;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refreshColumnCombo();
    }

    protected void refreshColumnCombo() {
        Object input = this.getInput();
        if (!this.isFillingCombo && (input instanceof QueryStatement || input instanceof QuerySelect)) {
            this.isFillingCombo = true;
            if (input instanceof QueryStatement) {
                this.currentStatement = (QueryStatement)input;
            }
            boolean isSelect = input instanceof QuerySelectStatement || input instanceof QuerySelect;
            this.totalRdbColumn = BuilderUtility.fillColumnComboBox(this.columnComboBoxCellEditor, (SQLQueryObject)input, isSelect, false);
            this.isFillingCombo = false;
        }
    }

    public void refresh() {
        if (!this.isCellEditorActive() && !this.isFillingCombo) {
            this.refreshColumnCombo();
            super.refresh();
        }
    }

    class ColumnNameComboBoxCellEditor
    extends ComboBoxCellEditor {
        public ColumnNameComboBoxCellEditor(Composite parent) {
            super(parent, null);
        }

        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }
    }
}

