/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.internal.EMFPropertyListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFListValueProperty
extends SimpleValueProperty {
    private final EStructuralFeature eStructuralFeature;
    private final IEMFListProperty.ListElementAccess elementAccess;

    public EMFListValueProperty(EStructuralFeature eStructuralFeature, IEMFListProperty.ListElementAccess elementAccess) {
        this.eStructuralFeature = eStructuralFeature;
        this.elementAccess = elementAccess;
    }

    public Object getValueType() {
        return this.eStructuralFeature;
    }

    protected Object doGetValue(Object source) {
        EObject eObject = (EObject)source;
        List list = (List)eObject.eGet(this.eStructuralFeature);
        int idx = this.elementAccess.getReadValueIndex(list);
        if (idx != -1) {
            return list.get(idx);
        }
        return null;
    }

    protected void doSetValue(Object source, Object value) {
        EObject eObject = (EObject)source;
        List list = (List)eObject.eGet(this.eStructuralFeature);
        IEMFListProperty.ListElementAccess.WriteData data = this.elementAccess.getWriteValueData(list);
        if (data != null) {
            this.doSetListValue((EObject)source, list, data, value);
        }
    }

    protected void doSetListValue(EObject source, List<Object> targetList, IEMFListProperty.ListElementAccess.WriteData data, Object value) {
        if (data.insert) {
            if (data.index == -1) {
                targetList.add(value);
            } else {
                targetList.add(data.index, value);
            }
        } else {
            targetList.set(data.index, value);
        }
    }

    public INativePropertyListener adaptListener(final ISimplePropertyListener listener) {
        return new EMFPropertyListener(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == this.getFeature() && !msg.isTouch()) {
                    Object newValue = EMFListValueProperty.this.doGetValue(msg.getNotifier());
                    this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)Diffs.createValueDiff(null, (Object)newValue)));
                }
            }

            protected IProperty getOwner() {
                return EMFListValueProperty.this;
            }

            protected ISimplePropertyListener getListener() {
                return listener;
            }

            protected EStructuralFeature getFeature() {
                return EMFListValueProperty.this.eStructuralFeature;
            }
        };
    }
}

