/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.jst.jsf.common.internal.finder.AbstractMatcher;
import org.eclipse.jst.jsf.common.internal.finder.VisitorMatcher;
import org.eclipse.jst.jsf.common.internal.finder.acceptor.JarEntryMatchingAcceptor;
import org.eclipse.jst.jsf.common.internal.finder.matcher.TaglibJarEntryFinder;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathJarFile;
import org.eclipse.jst.jsf.common.internal.resource.DefaultJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.IJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagModelLoader;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileFaceletTaglibLocator
extends AbstractFaceletTaglibLocator {
    public static final TaglibJarEntryFinder _taglibMetaInfFinder = new TaglibJarEntryFinder(Pattern.compile("META-INF/.*\\.taglib\\.xml"));
    public static final TaglibJarEntryFinder _taglibGlassfishFinder = new TaglibJarEntryFinder(Pattern.compile("com/sun/faces/metadata/taglib/.*\\.taglib\\.xml"));
    private static final List<AbstractMatcher.IMatcher> MATCHERS;
    private static final String DISPLAYNAME;
    private static final String ID;
    private final TagRecordFactory _factory;
    private final Map<String, IFaceletTagRecord> _records;
    private final IJarLocator _locator;
    private final List<AbstractMatcher.IMatcher> _jarEntryMatchers;

    static {
        ArrayList<TaglibJarEntryFinder> matchers = new ArrayList<TaglibJarEntryFinder>();
        matchers.add(_taglibGlassfishFinder);
        matchers.add(_taglibMetaInfFinder);
        MATCHERS = Collections.unmodifiableList(matchers);
        DISPLAYNAME = Messages.JarFileFaceletTaglibLocator_0;
        ID = JarFileFaceletTaglibLocator.class.getCanonicalName();
    }

    public JarFileFaceletTaglibLocator(TagRecordFactory factory) {
        this(factory, (IJarLocator)new DefaultJarLocator(Collections.singletonList(new AbstractMatcher.AlwaysMatcher()), new JavaCoreMediator()));
    }

    public JarFileFaceletTaglibLocator(TagRecordFactory factory, IJarLocator jarProvider) {
        this(factory, jarProvider, MATCHERS);
    }

    public JarFileFaceletTaglibLocator(TagRecordFactory factory, IJarLocator jarProvider, List<AbstractMatcher.IMatcher> jarEntryMatchers) {
        super(ID, DISPLAYNAME);
        this._factory = factory;
        this._records = new HashMap<String, IFaceletTagRecord>();
        this._locator = jarProvider;
        this._jarEntryMatchers = jarEntryMatchers;
    }

    public void start(IProject project) {
        this._locator.start((Object)project);
        ArrayList<LibJarEntry> tagLibsFound = new ArrayList<LibJarEntry>();
        Collection jars = this._locator.getJars(project);
        for (ClasspathJarFile cpJarFile : jars) {
            JarFile jarFile = cpJarFile.getJarFile();
            if (jarFile == null) continue;
            tagLibsFound.addAll(JarFileFaceletTaglibLocator.processJar(cpJarFile, this._jarEntryMatchers));
        }
        for (LibJarEntry jarEntry : tagLibsFound) {
            IFaceletTagRecord record = this._factory.createRecords(jarEntry.getTaglib(), new IFaceletTagRecord.JarTagRecordDescriptor(jarEntry.getPath(), jarEntry.getEntryName()));
            if (record == null) continue;
            this._records.put(record.getURI(), record);
        }
        this._locator.addListener(new IJarLocator.JarChangeListener(){

            public void changed(IJarLocator.JarChangeEvent event) {
                switch (event.getType()) {
                    case JAR_ADDED: {
                        ClasspathJarFile jar = event.getJar();
                        List foundLibs = JarFileFaceletTaglibLocator.processJar(jar, JarFileFaceletTaglibLocator.this._jarEntryMatchers);
                        for (LibJarEntry lib : foundLibs) {
                            IFaceletTagRecord newRecord = JarFileFaceletTaglibLocator.this._factory.createRecords(lib.getTaglib(), new IFaceletTagRecord.JarTagRecordDescriptor(lib.getPath(), lib.getEntryName()));
                            JarFileFaceletTaglibLocator.this._records.put(newRecord.getURI(), newRecord);
                            JarFileFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(JarFileFaceletTaglibLocator.this, null, newRecord, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED));
                        }
                        break;
                    }
                    case JAR_REMOVED: {
                        ClasspathJarFile jar = event.getJar();
                        ArrayList<IFaceletTagRecord> removeRecords = new ArrayList<IFaceletTagRecord>();
                        for (Map.Entry entry : JarFileFaceletTaglibLocator.this._records.entrySet()) {
                            if (!((IFaceletTagRecord)entry.getValue()).getDescriptor().getPath().equals((Object)jar.getPath())) continue;
                            removeRecords.add((IFaceletTagRecord)entry.getValue());
                        }
                        for (IFaceletTagRecord removeMe : removeRecords) {
                            JarFileFaceletTaglibLocator.this._records.remove(removeMe);
                            JarFileFaceletTaglibLocator.this.fireChangeEvent(new Listener.TaglibChangedEvent(JarFileFaceletTaglibLocator.this, removeMe, null, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED));
                        }
                        break;
                    }
                }
            }
        });
        super.start((Object)project);
    }

    public void stop() {
        this._locator.stop();
        super.stop();
    }

    @Override
    public Map<String, ? extends IFaceletTagRecord> doLocate(IProject project) {
        return Collections.unmodifiableMap(this._records);
    }

    private static List<LibJarEntry> processJar(ClasspathJarFile cpJarFile, List<AbstractMatcher.IMatcher> jarEntryMatchers) {
        ArrayList<LibJarEntry> tagLibsFound;
        block19: {
            tagLibsFound = new ArrayList<LibJarEntry>();
            JarFile jarFile = cpJarFile.getJarFile();
            try {
                try {
                    if (jarFile != null) {
                        JarEntryMatchingAcceptor acceptor = new JarEntryMatchingAcceptor();
                        VisitorMatcher matcher = new VisitorMatcher((Object)"", "", (VisitorMatcher.MatchingAcceptor)acceptor, jarEntryMatchers);
                        Collection matchingEntries = (Collection)matcher.find((Object)jarFile);
                        for (JarEntry jarEntry : matchingEntries) {
                            InputStream is = null;
                            try {
                                is = jarFile.getInputStream(jarEntry);
                                String name = jarEntry.getName();
                                TagModelLoader loader = new TagModelLoader(name);
                                loader.loadFromInputStream(is);
                                FaceletTaglib tagLib = loader.getTaglib();
                                if (tagLib == null) continue;
                                tagLibsFound.add(new LibJarEntry(tagLib, cpJarFile.getPath(), name));
                            }
                            catch (Exception ex) {
                                StringBuffer sb = new StringBuffer("Error initializing facelet registry entry");
                                if (jarEntry != null && ex instanceof Resource.IOWrappedException && ex.getCause() instanceof FeatureNotFoundException) {
                                    FeatureNotFoundException fnfex = (FeatureNotFoundException)ex.getCause();
                                    sb.append(" (");
                                    sb.append(jarFile.getName());
                                    sb.append("!");
                                    sb.append(jarEntry.getName());
                                    sb.append(" is invalid at line ");
                                    sb.append(fnfex.getLine());
                                    sb.append(", column ");
                                    sb.append(fnfex.getColumn());
                                    sb.append(")");
                                }
                                FaceletCorePlugin.log(sb.toString(), ex);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    JSFCorePlugin.log((Exception)e, (String)"While locating jar based facelet tag libraries");
                    if (jarFile == null) break block19;
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        FaceletCorePlugin.log("Error closing jar file", ioe);
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        FaceletCorePlugin.log("Error closing jar file", ioe);
                    }
                }
            }
        }
        return tagLibsFound;
    }

    private static class LibJarEntry {
        private final FaceletTaglib _taglib;
        private final String _entryName;
        private final IPath _iPath;

        public LibJarEntry(FaceletTaglib taglib, IPath iPath, String entryName) {
            this._taglib = taglib;
            this._iPath = iPath;
            this._entryName = entryName;
        }

        public FaceletTaglib getTaglib() {
            return this._taglib;
        }

        public String getEntryName() {
            return this._entryName;
        }

        public IPath getPath() {
            return this._iPath;
        }
    }
}

