/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.descriptors;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.pde.api.tools.internal.descriptors.FieldDescriptorImpl;
import org.eclipse.pde.api.tools.internal.descriptors.MemberDescriptorImpl;
import org.eclipse.pde.api.tools.internal.descriptors.MethodDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;

public class ReferenceTypeDescriptorImpl
extends MemberDescriptorImpl
implements IReferenceTypeDescriptor {
    private String fFullName = null;
    private String fSignature = null;
    private String fGenericSignature = null;

    ReferenceTypeDescriptorImpl(String name, IElementDescriptor parent) {
        super(name, parent);
    }

    ReferenceTypeDescriptorImpl(String name, IElementDescriptor parent, String genericSignature) {
        this(name, parent);
        this.fGenericSignature = genericSignature;
    }

    public IFieldDescriptor getField(String name) {
        return new FieldDescriptorImpl(name, this);
    }

    public IMethodDescriptor getMethod(String name, String signature) {
        return new MethodDescriptorImpl(name, this, signature);
    }

    public IReferenceTypeDescriptor getType(String simpleName) {
        return new ReferenceTypeDescriptorImpl(simpleName, this);
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public synchronized String getQualifiedName() {
        if (this.fFullName == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getPackage().getName());
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            ArrayList<IReferenceTypeDescriptor> all = null;
            IReferenceTypeDescriptor enclosingType = this.getEnclosingType();
            while (enclosingType != null) {
                if (all == null) {
                    all = new ArrayList<IReferenceTypeDescriptor>();
                }
                all.add(0, enclosingType);
                enclosingType = enclosingType.getEnclosingType();
            }
            if (all != null) {
                Iterator iterator = all.iterator();
                while (iterator.hasNext()) {
                    buffer.append(((IReferenceTypeDescriptor)iterator.next()).getName());
                    buffer.append('$');
                }
            }
            buffer.append(this.getName());
            this.fFullName = buffer.toString();
        }
        return this.fFullName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IReferenceTypeDescriptor) {
            IReferenceTypeDescriptor refType = (IReferenceTypeDescriptor)obj;
            return this.getQualifiedName().equals(refType.getQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    protected Comparable getComparable() {
        return this.getQualifiedName();
    }

    public int getElementType() {
        return 2;
    }

    public String getSignature() {
        if (this.fSignature == null) {
            StringBuffer buf = new StringBuffer();
            buf.append('L');
            buf.append(this.getQualifiedName());
            buf.append(';');
            this.fSignature = buf.toString();
        }
        return this.fSignature;
    }

    public String getGenericSignature() {
        return this.fGenericSignature;
    }

    public boolean isAnonymous() {
        if (this.getEnclosingType() != null) {
            try {
                Integer.parseInt(this.getName());
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }
}

