/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessors {
    public static final AnnotationProcessor NO_OP = new NoOpAP();

    public static AnnotationProcessor getCompositeAnnotationProcessor(AnnotationProcessor ... aps) {
        return new CompositeAnnotationProcessor(aps);
    }

    public static AnnotationProcessor getCompositeAnnotationProcessor(Collection<AnnotationProcessor> aps) {
        return new CompositeAnnotationProcessor(aps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompositeAnnotationProcessor
    implements AnnotationProcessor {
        private List<AnnotationProcessor> aps = new LinkedList<AnnotationProcessor>();

        public CompositeAnnotationProcessor(Collection<AnnotationProcessor> aps) {
            this.aps.addAll(aps);
        }

        public CompositeAnnotationProcessor(AnnotationProcessor ... aps) {
            AnnotationProcessor[] annotationProcessorArray = aps;
            int n = aps.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationProcessor ap = annotationProcessorArray[n2];
                this.aps.add(ap);
                ++n2;
            }
        }

        @Override
        public void process() {
            for (AnnotationProcessor ap : this.aps) {
                ap.process();
            }
        }
    }

    static class NoOpAP
    implements AnnotationProcessor {
        NoOpAP() {
        }

        public void process() {
        }
    }
}

