/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.dbws.eclipselink.core.gen;

import java.io.File;
import java.util.logging.Level;
import javax.wsdl.WSDLException;
import org.eclipse.jpt.dbws.eclipselink.core.gen.internal.Tools;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModelProject;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.EclipsePackager;

public class Main {
    private String builderFile;
    private String stageDir;
    private String packageAs;
    private boolean isDebugMode;

    public static void main(String[] args) {
        new Main().execute(args);
    }

    private Main() {
    }

    protected void execute(String[] args) {
        this.initializeWith(args);
        this.generate();
    }

    private void generate() {
        DBWSBuilder builder = new DBWSBuilder();
        DBWSBuilderModel model = this.buildBuilderModel(this.builderFile);
        if (model == null) {
            this.logMessage(Level.INFO, "NO_GENERATION_PERFORMED");
            return;
        }
        builder.setProperties(model.properties);
        builder.setOperations(model.operations);
        if (!this.jdbcDriverIsOnClasspath(builder.getDriver())) {
            return;
        }
        EclipsePackager packager = this.buildEclipsePackager();
        this.initializePackager((DBWSPackager)packager, builder, this.buildStageDir(this.stageDir));
        builder.setPackager((DBWSPackager)packager);
        try {
            builder.start();
        }
        catch (WSDLException e) {
            this.logMessage(Level.SEVERE, "WSDL_EXCEPTION", e.getMessage());
            return;
        }
        catch (Exception e) {
            this.logMessage(Level.SEVERE, "GENERATION_FAILED", e.getMessage());
            e.printStackTrace();
            return;
        }
        this.logMessage(Level.INFO, "GENERATION_COMPLETED");
    }

    private void initializeWith(String[] args) {
        this.builderFile = this.getArgumentBuilderFile(args);
        this.stageDir = this.getArgumentStageDir(args);
        this.packageAs = this.getArgumentPackageAs(args);
        this.isDebugMode = this.getArgumentDebugMode(args);
    }

    private void initializePackager(DBWSPackager packager, DBWSBuilder builder, File stageDir) {
        packager.setDBWSBuilder(builder);
        packager.setArchiveUse(DBWSPackager.ArchiveUse.ignore);
        packager.setAdditionalArgs(null);
        packager.setStageDir(stageDir);
        packager.setSessionsFileName(builder.getSessionsFileName());
    }

    private DBWSBuilderModel buildBuilderModel(String builderFileName) {
        File builderFile = this.getBuilderFile(builderFileName);
        return this.unmarshal(builderFile);
    }

    private DBWSBuilderModel unmarshal(File builderFile) {
        if (builderFile == null || !builderFile.exists()) {
            return null;
        }
        XMLContext context = new XMLContext((Project)new DBWSBuilderModelProject());
        XMLUnmarshaller unmarshaller = context.createUnmarshaller();
        DBWSBuilderModel model = (DBWSBuilderModel)unmarshaller.unmarshal(builderFile);
        if (model.properties.size() == 0) {
            this.logMessage(Level.SEVERE, "NO_OPERATIONS_SPECIFIED");
            return null;
        }
        return model;
    }

    private File getBuilderFile(String builderFileName) {
        File builderFile = new File(builderFileName);
        if (!builderFile.exists() || !builderFile.isFile()) {
            this.logMessage(Level.SEVERE, "UNABLE_TO_LOCATE_BUILDER_XML", builderFileName);
            return null;
        }
        return builderFile;
    }

    private File buildStageDir(String stageDirName) {
        File dir = new File(stageDirName);
        if (!dir.exists() || !dir.isDirectory()) {
            dir = Tools.buildDirectory(stageDirName);
        }
        return dir;
    }

    private EclipsePackager buildEclipsePackager() {
        return new EclipsePackager(){

            public void start() {
            }
        };
    }

    private boolean jdbcDriverIsOnClasspath(String jdbcDriverName) {
        try {
            Class.forName(jdbcDriverName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logMessage(Level.SEVERE, "DRIVER_NOT_ON_CLASSPATH", jdbcDriverName);
            return false;
        }
        return true;
    }

    private void logMessage(Level level, String key, Object argument) {
        Tools.logMessage(level, Tools.bind(key, argument));
    }

    private void logMessage(Level level, String key) {
        Tools.logMessage(level, Tools.getString(key));
    }

    private String getArgumentBuilderFile(String[] args) {
        return this.getArgumentValue("-builderFile", args);
    }

    private String getArgumentStageDir(String[] args) {
        return this.getArgumentValue("-stageDir", args);
    }

    private String getArgumentPackageAs(String[] args) {
        return this.getArgumentValue("-packageAs", args);
    }

    private boolean getArgumentDebugMode(String[] args) {
        return this.argumentExists("-debug", args);
    }

    private String getArgumentValue(String argName, String[] args) {
        int i = 0;
        while (i < args.length) {
            int j;
            String arg = args[i];
            if (arg.equals(argName) && (j = i + 1) < args.length) {
                return args[j];
            }
            ++i;
        }
        return null;
    }

    private boolean argumentExists(String argName, String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.toLowerCase().equals(argName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

