/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.search.ui.text.Match;
import org.osgi.framework.BundleException;

public class ClassSearchParticipant
implements IQueryParticipant {
    private static final int H_IMP = 0;
    private static final int H_EXP = 1;
    private static final int H_BUNACT = 2;
    private static final int H_PLUGCLASS = 3;
    private static final int H_TOTAL = 4;
    private static final String[] SEARCH_HEADERS = new String[4];
    private static final int S_LIMIT_REF = 2;
    private static final int S_LIMIT_ALL = 3;
    private static final int S_FOR_TYPES = 0;
    private static final int S_FOR_PACKAGES = 2;
    private ISearchRequestor fSearchRequestor;
    private Pattern fSearchPattern;
    private int fSearchFor = -1;

    static {
        ClassSearchParticipant.SEARCH_HEADERS[0] = "Import-Package";
        ClassSearchParticipant.SEARCH_HEADERS[1] = "Export-Package";
        ClassSearchParticipant.SEARCH_HEADERS[2] = "Bundle-Activator";
        ClassSearchParticipant.SEARCH_HEADERS[3] = "Plugin-Class";
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        String search;
        if (querySpecification.getLimitTo() != 2 && querySpecification.getLimitTo() != 3) {
            return;
        }
        if (querySpecification instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)querySpecification).getElement();
            search = element instanceof IType ? ((IType)element).getFullyQualifiedName('.') : element.getElementName();
            int type = element.getElementType();
            if (type == 7) {
                this.fSearchFor = 0;
            } else if (type == 4 || type == 3) {
                this.fSearchFor = 2;
            }
        } else {
            this.fSearchFor = ((PatternQuerySpecification)querySpecification).getSearchFor();
            search = ((PatternQuerySpecification)querySpecification).getPattern();
        }
        if (this.fSearchFor != 0 && this.fSearchFor != 2) {
            return;
        }
        this.fSearchPattern = PatternConstructor.createPattern((String)search, (boolean)true);
        this.fSearchRequestor = requestor;
        IPath[] enclosingPaths = querySpecification.getScope().enclosingProjectsAndJars();
        IPluginModelBase[] pluginModels = PluginRegistry.getWorkspaceModels();
        monitor.beginTask(PDEUIMessages.ClassSearchParticipant_taskMessage, pluginModels.length);
        int i = 0;
        while (i < pluginModels.length) {
            IProject project = pluginModels[i].getUnderlyingResource().getProject();
            if (!monitor.isCanceled() && this.encloses(enclosingPaths, project.getFullPath())) {
                this.searchProject(project, monitor);
            }
            ++i;
        }
    }

    private boolean encloses(IPath[] paths, IPath path) {
        int i = 0;
        while (i < paths.length) {
            if (paths[i].equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void searchProject(IProject project, IProgressMonitor monitor) throws CoreException {
        ModelModification mod = new ModelModification(project){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    IBundleModel bmodel = ((IBundlePluginModelBase)model).getBundleModel();
                    ClassSearchParticipant.this.inspectBundle(bmodel.getBundle());
                    model = ((IBundlePluginModelBase)model).getExtensionsModel();
                }
                if (model instanceof IPluginModelBase) {
                    IFile file = (IFile)((IPluginModelBase)model).getUnderlyingResource();
                    SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
                    IPluginBase pbase = ((IPluginModelBase)model).getPluginBase();
                    IPluginExtension[] extensions = pbase.getExtensions();
                    int j = 0;
                    while (j < extensions.length) {
                        ISchema schema = registry.getSchema(extensions[j].getPoint());
                        if (schema != null && !monitor.isCanceled()) {
                            ClassSearchParticipant.this.inspectExtension(schema, (IPluginParent)extensions[j], file);
                        }
                        ++j;
                    }
                }
            }
        };
        PDEModelUtility.modifyModel(mod, monitor);
    }

    private void inspectExtension(ISchema schema, IPluginParent parent, IFile file) {
        ISchemaElement schemaElement;
        IPluginObject[] children = parent.getChildren();
        if (parent instanceof PluginElementNode && parent != null && parent.getParent() instanceof PluginElementNode) {
            ISchemaAttribute attInfo;
            PluginElementNode node = (PluginElementNode)parent;
            PluginElementNode parentNode = (PluginElementNode)parent.getParent();
            schemaElement = schema.findElement(parentNode.getName());
            if (schemaElement != null && (attInfo = schemaElement.getAttribute(node.getName())) != null && attInfo.getKind() == 1) {
                this.checkMatch(node.getAttribute("class"), file);
            }
        }
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            schemaElement = schema.findElement(child.getName());
            if (schemaElement != null) {
                IPluginAttribute[] attributes = child.getAttributes();
                int j = 0;
                while (j < attributes.length) {
                    IPluginAttribute attr = attributes[j];
                    ISchemaAttribute attInfo = schemaElement.getAttribute(attr.getName());
                    if (attInfo != null && attInfo.getKind() == 1 && attr instanceof IDocumentAttributeNode) {
                        this.checkMatch(attr, file);
                    }
                    ++j;
                }
            }
            this.inspectExtension(schema, (IPluginParent)child, file);
            ++i;
        }
    }

    private void checkMatch(IPluginAttribute attr, IFile file) {
        String value = null;
        Matcher matcher = null;
        if (this.fSearchFor == 0) {
            value = this.removeInitializationData(attr.getValue()).replaceAll("\\$", ".");
            matcher = this.getMatcher(value);
        }
        if (value == null || matcher != null && !matcher.matches()) {
            value = this.removeInitializationData(this.getProperValue(attr.getValue())).replaceAll("\\$", ".");
            matcher = this.getMatcher(value);
        }
        if (matcher.matches()) {
            String group = matcher.group(0);
            int offset = ((IDocumentAttributeNode)attr).getValueOffset() + value.indexOf(group);
            int attOffset = attr.getValue().indexOf(value);
            if (attOffset != -1) {
                offset += attOffset;
            }
            int length = group.length();
            this.fSearchRequestor.reportMatch(new Match((Object)file, 2, offset, length));
        }
    }

    private String removeInitializationData(String attrValue) {
        int i = attrValue.indexOf(58);
        if (i != -1) {
            return attrValue.substring(0, i).trim();
        }
        return attrValue;
    }

    private void inspectBundle(IBundle bundle) {
        int i = 0;
        while (i < 4) {
            block10: {
                IManifestHeader header;
                if ((this.fSearchFor != 0 || i != 0 && i != 1) && (header = bundle.getManifestHeader(SEARCH_HEADERS[i])) != null) {
                    try {
                        ManifestElement[] elements = ManifestElement.parseHeader((String)header.getName(), (String)header.getValue());
                        if (elements == null) break block10;
                        int j = 0;
                        while (j < elements.length) {
                            String value = null;
                            Matcher matcher = null;
                            if (this.fSearchFor == 0) {
                                value = elements[j].getValue();
                                matcher = this.getMatcher(value);
                            }
                            if (value == null || matcher != null && !matcher.matches()) {
                                value = this.getProperValue(elements[j].getValue());
                                matcher = this.getMatcher(value);
                            }
                            if (matcher.matches()) {
                                int[] offlen;
                                String group = matcher.group(0);
                                try {
                                    offlen = this.getOffsetOfElement(bundle, header, group);
                                }
                                catch (CoreException coreException) {
                                    offlen = new int[]{header.getOffset(), header.getLength()};
                                }
                                this.fSearchRequestor.reportMatch(new Match((Object)bundle.getModel().getUnderlyingResource(), 2, offlen[0], offlen[1]));
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (BundleException bundleException) {}
                }
            }
            ++i;
        }
    }

    private Matcher getMatcher(String value) {
        return this.fSearchPattern.matcher(value.subSequence(0, value.length()));
    }

    private int[] getOffsetOfElement(IBundle bundle, IManifestHeader header, String value) throws CoreException {
        int[] offlen = new int[2];
        IBundleModel model = bundle.getModel();
        if (model instanceof IEditingModel) {
            IDocument pDoc = ((IEditingModel)model).getDocument();
            int headerOffset = header.getOffset() + header.getName().length();
            try {
                String headerString = pDoc.get(headerOffset, header.getLength() - header.getName().length());
                int internalOffset = headerString.indexOf(value);
                offlen[0] = internalOffset != -1 ? headerOffset + internalOffset : headerOffset + header.getName().length() + header.getValue().indexOf(value);
                offlen[1] = value.length();
            }
            catch (BadLocationException badLocationException) {}
        }
        return offlen;
    }

    private String getProperValue(String value) {
        return this.fSearchFor == 0 ? this.extractType(value) : this.extractPackage(value);
    }

    private String extractType(String value) {
        int index = value.lastIndexOf(".");
        if (index == -1 || index == value.length() - 1) {
            return value;
        }
        return value.substring(index + 1);
    }

    private String extractPackage(String value) {
        int index = value.lastIndexOf(".");
        if (index == -1 || index == value.length() - 1) {
            return value;
        }
        char afterPeriod = value.charAt(index + 1);
        if (afterPeriod >= 'A' && afterPeriod <= 'Z') {
            return value.substring(0, index);
        }
        return value;
    }

    public int estimateTicks(QuerySpecification specification) {
        return 100;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }
}

