/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.monitors;

import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class BundleUsageMonitor
implements UsageMonitor {
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String UNKNOWN = "unknown";
    private static final String UPDATED = "updated";
    private static final String UNRESOLVED = "unresolved";
    private static final String UNINSTALLED = "uninstalled";
    private static final String STOPPING = "stopping";
    private static final String STOPPED = "stopped";
    private static final String STARTING = "starting";
    private static final String RESOLVED = "resolved";
    private static final String LAZY_ACTIVATION = "lazy_activation";
    private static final String INSTALLED = "installed";
    private static final String STARTED = "started";
    private static final String BUNDLE = "bundle";
    private BundleListener bundleUsageListener;

    public void startMonitoring(final UsageDataService usageDataService) {
        this.recordCurrentlyActiveBundles(usageDataService);
        this.bundleUsageListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                usageDataService.recordEvent(BundleUsageMonitor.this.getWhatHappenedString(event), BundleUsageMonitor.BUNDLE, event.getBundle().getSymbolicName(), event.getBundle().getSymbolicName(), BundleUsageMonitor.this.getBundleVersion(event));
            }
        };
        this.getBundleContext().addBundleListener(this.bundleUsageListener);
    }

    private void recordCurrentlyActiveBundles(UsageDataService usageDataService) {
        Bundle[] bundleArray = this.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 32) {
                String bundleId = bundle.getSymbolicName();
                usageDataService.recordEvent(STARTED, BUNDLE, bundleId, bundleId, this.getBundleVersion(bundle));
            }
            ++n2;
        }
    }

    protected String getWhatHappenedString(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                return INSTALLED;
            }
            case 512: {
                return LAZY_ACTIVATION;
            }
            case 32: {
                return RESOLVED;
            }
            case 2: {
                return STARTED;
            }
            case 128: {
                return STARTING;
            }
            case 4: {
                return STOPPED;
            }
            case 256: {
                return STOPPING;
            }
            case 16: {
                return UNINSTALLED;
            }
            case 64: {
                return UNRESOLVED;
            }
            case 8: {
                return UPDATED;
            }
        }
        return UNKNOWN;
    }

    protected String getBundleVersion(BundleEvent event) {
        return this.getBundleVersion(event.getBundle());
    }

    private String getBundleVersion(Bundle bundle) {
        return (String)bundle.getHeaders().get(BUNDLE_VERSION);
    }

    public void stopMonitoring() {
        this.getBundleContext().removeBundleListener(this.bundleUsageListener);
    }

    private BundleContext getBundleContext() {
        return UsageDataCaptureActivator.getDefault().getBundle().getBundleContext();
    }
}

