/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;
import org.eclipse.epp.usagedata.internal.gathering.settings.UsageDataCaptureSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class UsageDataCaptureActivator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.epp.usagedata.gathering";
    private static UsageDataCaptureActivator plugin;
    private ServiceRegistration registration;
    private ServiceTracker usageDataServiceTracker;
    private UsageDataCaptureSettings settings;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.context = context;
        this.settings = new UsageDataCaptureSettings();
        final UsageDataService service = new UsageDataService();
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.epp.usagedata.gathering.enabled".equals(event.getProperty())) {
                    if (this.isTrue(event.getNewValue())) {
                        service.startMonitoring();
                    } else {
                        service.stopMonitoring();
                    }
                }
            }

            private boolean isTrue(Object newValue) {
                if (newValue instanceof Boolean) {
                    return (Boolean)newValue;
                }
                if (newValue instanceof String) {
                    return Boolean.valueOf((String)newValue);
                }
                return false;
            }
        });
        this.registration = context.registerService(UsageDataService.class.getName(), (Object)service, null);
        this.usageDataServiceTracker = new ServiceTracker(context, UsageDataService.class.getName(), null);
        this.usageDataServiceTracker.open();
        UIJob job = new UIJob("Usage Data Service Starter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (UsageDataCaptureActivator.this.settings.isEnabled()) {
                    service.startMonitoring();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(1000L);
    }

    public void stop(BundleContext context) throws Exception {
        this.context = context;
        UsageDataService service = this.getUsageDataCaptureService();
        if (service != null) {
            service.stopMonitoring();
        }
        this.usageDataServiceTracker.close();
        this.registration.unregister();
        plugin = null;
        super.stop(context);
    }

    private UsageDataService getUsageDataCaptureService() {
        return (UsageDataService)this.usageDataServiceTracker.getService();
    }

    public static UsageDataCaptureActivator getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    public void logException(String message, Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public UsageDataCaptureSettings getSettings() {
        return this.settings;
    }

    public BundleContext getContext() {
        return this.context;
    }
}

