/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ConstructorPattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    public boolean varargs = false;
    char[][][] parametersTypeSignatures;
    char[][][][] parametersTypeArguments;
    boolean constructorParameters = false;
    char[][] constructorArguments;
    protected static char[][] REF_CATEGORIES = new char[][]{CONSTRUCTOR_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{CONSTRUCTOR_REF, CONSTRUCTOR_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{CONSTRUCTOR_DECL};

    public static char[] createIndexKey(char[] typeName, int argCount) {
        char[] countChars = argCount < 10 ? COUNTS[argCount] : ("/" + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(typeName, countChars);
    }

    ConstructorPattern(int matchRule) {
        super(32, matchRule);
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, char[][] parameterQualifications, char[][] parameterSimpleNames, int matchRule) {
        this(matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        char[] cArray = this.declaringSimpleName = this.isCaseSensitive() || this.isCamelCase() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterCount = parameterSimpleNames.length;
            boolean synthetic = this.parameterCount > 0 && declaringQualification != null && CharOperation.equals(CharOperation.concat(parameterQualifications[0], parameterSimpleNames[0], '.'), declaringQualification);
            int offset = 0;
            if (synthetic) {
                --this.parameterCount;
                ++offset;
            }
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterQualifications[i] = this.isCaseSensitive() ? parameterQualifications[i + offset] : CharOperation.toLowerCase(parameterQualifications[i + offset]);
                this.parameterSimpleNames[i] = this.isCaseSensitive() ? parameterSimpleNames[i + offset] : CharOperation.toLowerCase(parameterSimpleNames[i + offset]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.mustResolve = this.mustResolve();
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, char[][] parameterQualifications, char[][] parameterSimpleNames, String[] parameterSignatures, IFunction method, int matchRule) {
        this(findDeclarations, findReferences, declaringSimpleName, declaringQualification, parameterQualifications, parameterSimpleNames, matchRule);
        int length;
        try {
            this.varargs = (method.getFlags() & 0x80) != 0;
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        this.constructorParameters = true;
        this.storeTypeSignaturesAndArguments(method.getDeclaringType());
        if (parameterSignatures != null && (length = parameterSignatures.length) > 0) {
            this.parametersTypeSignatures = new char[length][][];
            this.parametersTypeArguments = new char[length][][][];
            int i = 0;
            while (i < length) {
                this.parametersTypeSignatures[i] = Util.splitTypeLevelsSignature(parameterSignatures[i]);
                this.parametersTypeArguments[i] = Util.getAllTypeArguments(this.parametersTypeSignatures[i]);
                ++i;
            }
        }
        this.constructorArguments = this.extractMethodArguments(method);
        if (this.hasConstructorArguments()) {
            this.mustResolve = true;
        }
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, String declaringSignature, char[][] parameterQualifications, char[][] parameterSimpleNames, String[] parameterSignatures, char[][] arguments, int matchRule) {
        this(findDeclarations, findReferences, declaringSimpleName, declaringQualification, parameterQualifications, parameterSimpleNames, matchRule);
        int length;
        if (declaringSignature != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(declaringSignature);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        }
        if (parameterSignatures != null && (length = parameterSignatures.length) > 0) {
            this.parametersTypeSignatures = new char[length][][];
            this.parametersTypeArguments = new char[length][][][];
            int i = 0;
            while (i < length) {
                this.parametersTypeSignatures[i] = Util.splitTypeLevelsSignature(parameterSignatures[i]);
                this.parametersTypeArguments[i] = Util.getAllTypeArguments(this.parametersTypeSignatures[i]);
                ++i;
            }
        }
        this.constructorArguments = arguments;
        if ((arguments == null || arguments.length == 0) && this.getTypeArguments() != null && this.getTypeArguments().length > 0) {
            this.constructorArguments = this.getTypeArguments()[0];
        }
        if (this.hasConstructorArguments()) {
            this.mustResolve = true;
        }
    }

    public void decodeIndexKey(char[] key) {
        int last = key.length - 1;
        this.parameterCount = 0;
        this.declaringSimpleName = null;
        int power = 1;
        int i = last;
        while (i >= 0) {
            if (key[i] == '/') {
                this.declaringSimpleName = new char[i];
                System.arraycopy(key, 0, this.declaringSimpleName, 0, i);
                break;
            }
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
    }

    public SearchPattern getBlankPattern() {
        return new ConstructorPattern(8);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean hasConstructorArguments() {
        return this.constructorArguments != null && this.constructorArguments.length > 0;
    }

    boolean hasConstructorParameters() {
        return this.constructorParameters;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        ConstructorPattern pattern = (ConstructorPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.declaringSimpleName, pattern.declaringSimpleName);
    }

    protected boolean mustResolve() {
        if (this.declaringQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (this.parameterQualifications[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return this.findReferences;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.declaringSimpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                if (this.declaringSimpleName != null && this.parameterCount >= 0 && !this.varargs) {
                    key = ConstructorPattern.createIndexKey(this.declaringSimpleName, this.parameterCount);
                    break;
                }
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0 && !this.varargs) {
                    key = ConstructorPattern.createIndexKey(this.declaringSimpleName == null ? ONE_STAR : this.declaringSimpleName, this.parameterCount);
                    break;
                }
                if (this.declaringSimpleName == null || this.declaringSimpleName[this.declaringSimpleName.length - 1] == '*') break;
                key = CharOperation.concat(this.declaringSimpleName, ONE_STAR, '/');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "ConstructorCombinedPattern: " : "ConstructorDeclarationPattern: ");
        } else {
            output.append("ConstructorReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            output.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            output.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            output.append("*");
        }
        output.append('(');
        if (this.parameterSimpleNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    output.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    output.append('*');
                } else {
                    output.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        output.append(')');
        return super.print(output);
    }
}

