/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableItemModelAdapter {
    protected final TableItem tableItem;
    protected final DisposeListener tableItemDisposeListener;
    private ColumnAdapter<Object> columnAdapter;
    private WritablePropertyValueModel<?>[] valueHolders;
    private PropertyChangeListener[] propertyChangeListeners;
    private ITableLabelProvider labelProvider;

    public static TableItemModelAdapter adapt(TableItem tableItem, ColumnAdapter<?> columnAdapter, ITableLabelProvider labelProvider) {
        return new TableItemModelAdapter(tableItem, columnAdapter, labelProvider);
    }

    protected TableItemModelAdapter(TableItem tableItem, ColumnAdapter<?> columnAdapter, ITableLabelProvider labelProvider) {
        if (tableItem == null || columnAdapter == null || labelProvider == null) {
            throw new NullPointerException();
        }
        this.tableItem = tableItem;
        this.labelProvider = labelProvider;
        this.columnAdapter = columnAdapter;
        this.tableItemDisposeListener = this.buildTableItemDisposeListener();
        this.tableItem.addDisposeListener(this.tableItemDisposeListener);
        this.valueHolders = this.columnAdapter.cellModels(tableItem.getData());
        this.propertyChangeListeners = this.buildPropertyChangeListeners();
        int index = this.columnAdapter.columnCount();
        while (--index >= 0) {
            this.tableItemChanged(index, tableItem.getData(), false);
            this.valueHolders[index].addPropertyChangeListener("value", this.propertyChangeListeners[index]);
        }
    }

    private PropertyChangeListener[] buildPropertyChangeListeners() {
        PropertyChangeListener[] listeners = new PropertyChangeListener[this.columnAdapter.columnCount()];
        int index = listeners.length;
        while (--index >= 0) {
            listeners[index] = this.buildPropertyChangeListener(index);
        }
        return listeners;
    }

    protected PropertyChangeListener buildPropertyChangeListener(int index) {
        return new SWTPropertyChangeListenerWrapper(this.buildPropertyChangeListener_(index));
    }

    protected PropertyChangeListener buildPropertyChangeListener_(int index) {
        return new TableItemPropertyChangeListener(index);
    }

    protected DisposeListener buildTableItemDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TableItemModelAdapter.this.tableItemDisposed(event);
            }

            public String toString() {
                return "TableItem dispose listener";
            }
        };
    }

    protected void tableItemChanged(int index, Object subject, boolean revalidate) {
        if (!this.tableItem.isDisposed()) {
            this.updateTableItemText(index, subject);
            this.updateTableItemImage(index, subject);
            if (revalidate) {
                this.layoutTable();
            }
        }
    }

    private void updateTableItemText(int index, Object subject) {
        String text = this.labelProvider.getColumnText(subject, index);
        if (text == null) {
            text = "";
        }
        this.tableItem.setText(index, text);
    }

    private void updateTableItemImage(int index, Object subject) {
        Image image = this.labelProvider.getColumnImage(subject, index);
        this.tableItem.setImage(index, image);
    }

    private void layoutTable() {
        Composite container = this.tableItem.getParent().getParent();
        container.computeSize(-1, -1);
        container.layout();
    }

    protected void tableItemDisposed(DisposeEvent event) {
        this.tableItem.removeDisposeListener(this.tableItemDisposeListener);
        int index = this.valueHolders.length;
        while (--index >= 0) {
            this.valueHolders[index].removePropertyChangeListener("value", this.propertyChangeListeners[index]);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }

    private class TableItemPropertyChangeListener
    implements PropertyChangeListener {
        private final int index;

        TableItemPropertyChangeListener(int index) {
            this.index = index;
        }

        public void propertyChanged(PropertyChangeEvent event) {
            if (!TableItemModelAdapter.this.tableItem.isDisposed()) {
                Table table = TableItemModelAdapter.this.tableItem.getParent();
                TableItemModelAdapter.this.tableItemChanged(this.index, TableItemModelAdapter.this.tableItem.getData(), table.getColumnCount() == 0);
            }
        }
    }
}

