/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jpt.common.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemLabelProvider
implements ItemLabelProvider {
    private DelegatingContentAndLabelProvider labelProvider;
    private Model model;
    private PropertyValueModel<Image> imageModel;
    private PropertyValueModel<String> textModel;
    private PropertyValueModel<String> descriptionModel;
    private PropertyChangeListener labelChangeListener;

    protected AbstractItemLabelProvider(Model model, DelegatingContentAndLabelProvider labelProvider) {
        this.model = model;
        this.labelProvider = labelProvider;
        this.labelChangeListener = this.buildLabelChangeListener();
    }

    protected PropertyChangeListener buildLabelChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                AbstractItemLabelProvider.this.getLabelProvider().updateLabel(AbstractItemLabelProvider.this.getModel());
            }
        };
    }

    protected synchronized PropertyValueModel<Image> getImageModel() {
        if (this.imageModel == null) {
            this.imageModel = this.buildImageModel();
            this.engageImageModel();
        }
        return this.imageModel;
    }

    protected abstract PropertyValueModel<Image> buildImageModel();

    protected void engageImageModel() {
        this.imageModel.addPropertyChangeListener("value", this.labelChangeListener);
    }

    protected void disengageImageModel() {
        this.imageModel.removePropertyChangeListener("value", this.labelChangeListener);
    }

    protected synchronized PropertyValueModel<String> getTextModel() {
        if (this.textModel == null) {
            this.textModel = this.buildTextModel();
            this.engageTextModel();
        }
        return this.textModel;
    }

    protected abstract PropertyValueModel<String> buildTextModel();

    protected void engageTextModel() {
        this.textModel.addPropertyChangeListener("value", this.labelChangeListener);
    }

    protected void disengageTextModel() {
        this.textModel.removePropertyChangeListener("value", this.labelChangeListener);
    }

    protected synchronized PropertyValueModel<String> getDescriptionModel() {
        if (this.descriptionModel == null) {
            this.descriptionModel = this.buildDescriptionModel();
            this.engageDescriptionModel();
        }
        return this.descriptionModel;
    }

    protected abstract PropertyValueModel<String> buildDescriptionModel();

    protected void engageDescriptionModel() {
        this.descriptionModel.addPropertyChangeListener("value", this.labelChangeListener);
    }

    protected void disengageDescriptionModel() {
        this.descriptionModel.removePropertyChangeListener("value", this.labelChangeListener);
    }

    public Model getModel() {
        return this.model;
    }

    public DelegatingContentAndLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public Image getImage() {
        return (Image)this.getImageModel().getValue();
    }

    @Override
    public String getText() {
        return (String)this.getTextModel().getValue();
    }

    @Override
    public String getDescription() {
        return (String)this.getDescriptionModel().getValue();
    }

    @Override
    public void dispose() {
        this.disposeTextModel();
        this.disposeImageModel();
        this.disposeDescriptionModel();
    }

    protected synchronized void disposeTextModel() {
        if (this.textModel != null) {
            this.disengageTextModel();
            this.textModel = null;
        }
    }

    protected synchronized void disposeImageModel() {
        if (this.imageModel != null) {
            this.disengageImageModel();
            this.imageModel = null;
        }
    }

    protected synchronized void disposeDescriptionModel() {
        if (this.descriptionModel != null) {
            this.disengageDescriptionModel();
            this.descriptionModel = null;
        }
    }
}

