/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.logging;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.logging.Logger;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.logging.Logging;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerComposite
extends ClassChooserComboPane<Logging> {
    public LoggerComposite(Pane<? extends Logging> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected String getClassName() {
        if (((Logging)this.getSubject()).getLogger() == null) {
            return "org.eclipse.persistence.logging.DefaultSessionLog";
        }
        return Logger.getLoggerClassName((String)((Logging)this.getSubject()).getLogger());
    }

    protected String getLabelText() {
        return EclipseLinkUiMessages.PersistenceXmlLoggingTab_loggerLabel;
    }

    protected IJavaProject getJavaProject() {
        return ((Logging)this.getSubject()).getJpaProject().getJavaProject();
    }

    protected String getSuperInterfaceName() {
        return "org.eclipse.persistence.logging.SessionLog";
    }

    protected WritablePropertyValueModel<String> buildTextHolder() {
        return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{"logger"}){

            protected String buildValue_() {
                String name = ((Logging)this.subject).getLogger();
                if (name == null) {
                    name = LoggerComposite.this.getDefaultValue((Logging)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (LoggerComposite.this.getDefaultValue((Logging)this.subject).equals(value)) {
                    value = null;
                }
                ((Logging)this.subject).setLogger(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultLoggerHolder() {
        return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{Logging.DEFAULT_LOGGER}){

            protected String buildValue_() {
                return LoggerComposite.this.getDefaultValue((Logging)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultLoggerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultLoggerHolder());
    }

    private String buildDisplayString(String loggerName) {
        switch (Logger.valueOf((String)loggerName)) {
            case default_logger: {
                return EclipseLinkUiMessages.LoggerComposite_default_logger;
            }
            case java_logger: {
                return EclipseLinkUiMessages.LoggerComposite_java_logger;
            }
            case server_logger: {
                return EclipseLinkUiMessages.LoggerComposite_server_logger;
            }
        }
        return null;
    }

    private Comparator<String> buildLoggerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String logger1, String logger2) {
                logger1 = LoggerComposite.this.buildDisplayString(logger1);
                logger2 = LoggerComposite.this.buildDisplayString(logger2);
                return Collator.getInstance().compare(logger1, logger2);
            }
        };
    }

    protected StringConverter<String> buildClassConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    Logger.valueOf((String)value);
                    value = LoggerComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    protected ListValueModel<String> buildClassListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultLoggerListHolder());
        holders.add(this.buildLoggersListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildLoggers() {
        return new TransformationIterator<Logger, String>(CollectionTools.iterator((Object[])Logger.values())){

            protected String transform(Logger next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildLoggersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildLoggers()));
    }

    private ListValueModel<String> buildLoggersListHolder() {
        return new SortedListValueModelAdapter(this.buildLoggersCollectionHolder(), this.buildLoggerComparator());
    }

    private String getDefaultValue(Logging subject) {
        String defaultValue = subject.getDefaultLogger();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DefaultWithOneParam, (Object)defaultValue);
        }
        return JptCommonUiMessages.DefaultEmpty;
    }

    protected void setClassName(String className) {
        ((Logging)this.getSubject()).setLogger(className);
    }
}

