/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementDeclAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlElementDeclAnnotation
extends SourceAnnotation<MethodAttribute>
implements XmlElementDeclAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlElementDecl");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceXmlElementDeclAnnotation.buildNameAdapter();
    private final AnnotationElementAdapter<String> nameAdapter = this.buildAnnotationElementAdapter(NAME_ADAPTER);
    private String name;
    private static final DeclarationAnnotationElementAdapter<String> NAMESPACE_ADAPTER = SourceXmlElementDeclAnnotation.buildNamespaceAdapter();
    private final AnnotationElementAdapter<String> namespaceAdapter = this.buildAnnotationElementAdapter(NAMESPACE_ADAPTER);
    private String namespace;
    private static final DeclarationAnnotationElementAdapter<String> DEFAULT_VALUE_ADAPTER = SourceXmlElementDeclAnnotation.buildDefaultValueAdapter();
    private final AnnotationElementAdapter<String> defaultValueAdapter = this.buildAnnotationElementAdapter(DEFAULT_VALUE_ADAPTER);
    private String defaultValue;
    private static final DeclarationAnnotationElementAdapter<String> SCOPE_ADAPTER = SourceXmlElementDeclAnnotation.buildScopeAdapter();
    private final AnnotationElementAdapter<String> scopeAdapter = this.buildAnnotationElementAdapter(SCOPE_ADAPTER);
    private String scope;
    private String fullyQualifiedScopeClassName;
    private static final DeclarationAnnotationElementAdapter<String> SUBSTITUTION_HEAD_NAME_ADAPTER = SourceXmlElementDeclAnnotation.buildSubstitutionHeadNameAdapter();
    private final AnnotationElementAdapter<String> substitutionHeadNameAdapter = this.buildAnnotationElementAdapter(SUBSTITUTION_HEAD_NAME_ADAPTER);
    private String substitutionHeadName;
    private static final DeclarationAnnotationElementAdapter<String> SUBSTITUTION_HEAD_NAMESPACE_ADAPTER = SourceXmlElementDeclAnnotation.buildSubstitutionHeadNamespaceAdapter();
    private final AnnotationElementAdapter<String> substitutionHeadNamespaceAdapter = this.buildAnnotationElementAdapter(SUBSTITUTION_HEAD_NAMESPACE_ADAPTER);
    private String substitutionHeadNamespace;

    public SourceXmlElementDeclAnnotation(JavaResourceMethod parent, MethodAttribute method) {
        super(parent, method, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)method, DECLARATION_ANNOTATION_ADAPTER));
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    @Override
    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElementDecl";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.namespace = this.buildNamespace(astRoot);
        this.defaultValue = this.buildDefaultValue(astRoot);
        this.scope = this.buildScope(astRoot);
        this.fullyQualifiedScopeClassName = this.buildFullyQualifiedScopeClassName(astRoot);
        this.substitutionHeadName = this.buildSubstitutionHeadName(astRoot);
        this.substitutionHeadNamespace = this.buildSubstitutionHeadNamespace(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncNamespace(this.buildNamespace(astRoot));
        this.syncDefaultValue(this.buildDefaultValue(astRoot));
        this.syncScope(this.buildScope(astRoot));
        this.syncFullyQualifiedScopeClassName(this.buildFullyQualifiedScopeClassName(astRoot));
        this.syncSubstitutionHeadName(this.buildSubstitutionHeadName(astRoot));
        this.syncSubstitutionHeadNamespace(this.buildSubstitutionHeadNamespace(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (this.attributeValueHasChanged(this.namespace, namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(CompilationUnit astRoot) {
        return (String)this.namespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAMESPACE_ADAPTER, astRoot);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (this.attributeValueHasChanged(this.defaultValue, defaultValue)) {
            this.defaultValue = defaultValue;
            this.defaultValueAdapter.setValue((Object)defaultValue);
        }
    }

    private void syncDefaultValue(String astDefaultValue) {
        String old = this.defaultValue;
        this.defaultValue = astDefaultValue;
        this.firePropertyChanged("defaultValue", old, astDefaultValue);
    }

    private String buildDefaultValue(CompilationUnit astRoot) {
        return (String)this.defaultValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDefaultValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DEFAULT_VALUE_ADAPTER, astRoot);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        if (this.attributeValueHasChanged(this.scope, scope)) {
            this.scope = scope;
            this.scopeAdapter.setValue((Object)scope);
        }
    }

    private void syncScope(String astScope) {
        String old = this.scope;
        this.scope = astScope;
        this.firePropertyChanged("scope", old, astScope);
    }

    private String buildScope(CompilationUnit astRoot) {
        return (String)this.scopeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getScopeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SCOPE_ADAPTER, astRoot);
    }

    @Override
    public String getFullyQualifiedScopeClassName() {
        return this.fullyQualifiedScopeClassName;
    }

    private void syncFullyQualifiedScopeClassName(String name) {
        String old = this.fullyQualifiedScopeClassName;
        this.fullyQualifiedScopeClassName = name;
        this.firePropertyChanged("fullyQualifiedScopeClassName", old, name);
    }

    private String buildFullyQualifiedScopeClassName(CompilationUnit astRoot) {
        return this.scope == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.scopeAdapter.getExpression(astRoot));
    }

    @Override
    public String getSubstitutionHeadName() {
        return this.substitutionHeadName;
    }

    @Override
    public void setSubstitutionHeadName(String substitutionHeadName) {
        if (this.attributeValueHasChanged(this.substitutionHeadName, substitutionHeadName)) {
            this.substitutionHeadName = substitutionHeadName;
            this.substitutionHeadNameAdapter.setValue((Object)substitutionHeadName);
        }
    }

    private void syncSubstitutionHeadName(String astSubstitutionHeadName) {
        String old = this.substitutionHeadName;
        this.substitutionHeadName = astSubstitutionHeadName;
        this.firePropertyChanged("substitutionHeadName", old, astSubstitutionHeadName);
    }

    private String buildSubstitutionHeadName(CompilationUnit astRoot) {
        return (String)this.substitutionHeadNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSubstitutionHeadNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SUBSTITUTION_HEAD_NAME_ADAPTER, astRoot);
    }

    @Override
    public String getSubstitutionHeadNamespace() {
        return this.substitutionHeadNamespace;
    }

    @Override
    public void setSubstitutionHeadNamespace(String substitutionHeadNamespace) {
        if (this.attributeValueHasChanged(this.substitutionHeadNamespace, substitutionHeadNamespace)) {
            this.substitutionHeadNamespace = substitutionHeadNamespace;
            this.substitutionHeadNamespaceAdapter.setValue((Object)substitutionHeadNamespace);
        }
    }

    private void syncSubstitutionHeadNamespace(String astSubstitutionHeadNamespace) {
        String old = this.substitutionHeadNamespace;
        this.substitutionHeadNamespace = astSubstitutionHeadNamespace;
        this.firePropertyChanged("substitutionHeadNamespace", old, astSubstitutionHeadNamespace);
    }

    private String buildSubstitutionHeadNamespace(CompilationUnit astRoot) {
        return (String)this.substitutionHeadNamespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSubstitutionHeadNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SUBSTITUTION_HEAD_NAMESPACE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"name");
    }

    private static DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"namespace");
    }

    private static DeclarationAnnotationElementAdapter<String> buildDefaultValueAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"defaultValue");
    }

    private static DeclarationAnnotationElementAdapter<String> buildScopeAdapter() {
        return SourceXmlElementDeclAnnotation.buildAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "scope", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildSubstitutionHeadNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"substitutionHeadName");
    }

    private static DeclarationAnnotationElementAdapter<String> buildSubstitutionHeadNamespaceAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"substitutionHeadNamespace");
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }
}

