/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TreeIterable;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceAbstractType;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceEnum;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceField;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceField;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceType
extends SourceAbstractType<Type>
implements JavaResourceType {
    private String superclassQualifiedName;
    private boolean abstract_;
    private boolean hasNoArgConstructor;
    private final Vector<JavaResourceType> types = new Vector();
    private final Vector<JavaResourceEnum> enums = new Vector();
    private final Vector<JavaResourceField> fields = new Vector();
    private final Vector<JavaResourceMethod> methods = new Vector();

    static JavaResourceType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, TypeDeclaration typeDeclaration, CompilationUnit astRoot) {
        JDTType type = new JDTType(typeDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceType jrpt = new SourceType(javaResourceCompilationUnit, (Type)type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private static JavaResourceType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceType jrpt = new SourceType(javaResourceCompilationUnit, (Type)type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private SourceType(JavaResourceCompilationUnit javaResourceCompilationUnit, Type type) {
        super(javaResourceCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ITypeBinding binding = ((Type)this.annotatedElement).getBinding(astRoot);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName(binding);
        this.abstract_ = this.buildAbstract(binding);
        this.hasNoArgConstructor = this.buildHasNoArgConstructor(binding);
        this.initializeTypes(astRoot);
        this.initializeEnums(astRoot);
        this.initializeFields(astRoot);
        this.initializeMethods(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        ITypeBinding binding = ((Type)this.annotatedElement).getBinding(astRoot);
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(binding));
        this.syncAbstract(this.buildAbstract(binding));
        this.syncHasNoArgConstructor(this.buildHasNoArgConstructor(binding));
        this.syncTypes(astRoot);
        this.syncEnums(astRoot);
        this.syncFields(astRoot);
        this.syncMethods(astRoot);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(((Type)this.annotatedElement).getBinding(astRoot)));
        for (JavaResourceField field : this.getFields()) {
            field.resolveTypes(astRoot);
        }
        this.syncMethods(astRoot);
        for (JavaResourceMethod method : this.getMethods()) {
            method.resolveTypes(astRoot);
        }
        for (JavaResourceType type : this.getTypes()) {
            type.resolveTypes(astRoot);
        }
        for (JavaResourceEnum enum_ : this.getEnums()) {
            enum_.resolveTypes(astRoot);
        }
    }

    @Override
    public JavaResourceAbstractType.Kind getKind() {
        return JavaResourceAbstractType.Kind.TYPE;
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void syncSuperclassQualifiedName(String astSuperclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = astSuperclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, astSuperclassQualifiedName);
    }

    private String buildSuperclassQualifiedName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding superclass = binding.getSuperclass();
        return superclass == null ? null : superclass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void syncAbstract(boolean astAbstract) {
        boolean old = this.abstract_;
        this.abstract_ = astAbstract;
        this.firePropertyChanged("abstract", old, astAbstract);
    }

    private boolean buildAbstract(ITypeBinding binding) {
        return binding == null ? false : Modifier.isAbstract((int)binding.getModifiers());
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private void syncHasNoArgConstructor(boolean hasNoArgConstructor) {
        boolean old = this.hasNoArgConstructor;
        this.hasNoArgConstructor = hasNoArgConstructor;
        this.firePropertyChanged("noArgConstructor", old, hasNoArgConstructor);
    }

    private boolean buildHasNoArgConstructor(ITypeBinding binding) {
        return binding == null ? false : SourceType.typeHasNoArgConstructor(binding);
    }

    protected static boolean typeHasNoArgConstructor(ITypeBinding binding) {
        return SourceType.findNoArgConstructor(binding) != null;
    }

    protected static IMethodBinding findNoArgConstructor(ITypeBinding binding) {
        IMethodBinding[] iMethodBindingArray = binding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.isConstructor() && method.getParameterTypes().length == 0) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Iterable<JavaResourceType> getTypes() {
        return new LiveCloneIterable(this.types);
    }

    @Override
    public Iterable<JavaResourceType> getAllTypes() {
        return new TreeIterable<JavaResourceType>((JavaResourceType)this){

            protected Iterator<? extends JavaResourceType> children(JavaResourceType type) {
                return type.getTypes().iterator();
            }
        };
    }

    private JavaResourceType getType(String typeName, int occurrence) {
        for (JavaResourceType type : this.getTypes()) {
            if (!type.isFor(typeName, occurrence)) continue;
            return type;
        }
        return null;
    }

    private void addType(JavaResourceType type) {
        this.addItemToCollection(type, this.types, "types");
    }

    private void removeTypes(Collection<JavaResourceType> remove) {
        this.removeItemsFromCollection(remove, this.types, "types");
    }

    private void initializeTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.annotatedElement).getTypes(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(typeDeclarations.length);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration td = typeDeclarationArray[n2];
            String tdName = td.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.types.add(this.buildType(td, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.annotatedElement).getTypes(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(typeDeclarations.length);
        HashSet<JavaResourceType> typesToRemove = new HashSet<JavaResourceType>(this.types);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            String tdName = typeDeclaration.getName().getFullyQualifiedName();
            JavaResourceType type = this.getType(tdName, occurrence = counters.increment(tdName));
            if (type == null) {
                this.addType(this.buildType(typeDeclaration, occurrence, astRoot));
            } else {
                typesToRemove.remove(type);
                type.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeTypes(typesToRemove);
    }

    private JavaResourceType buildType(TypeDeclaration nestedTypeDeclaration, int occurrence, CompilationUnit astRoot) {
        return SourceType.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.annotatedElement, nestedTypeDeclaration, occurrence, astRoot);
    }

    @Override
    public Iterable<JavaResourceEnum> getEnums() {
        return new LiveCloneIterable(this.enums);
    }

    @Override
    public Iterable<JavaResourceEnum> getAllEnums() {
        return this.getEnums();
    }

    private JavaResourceEnum getEnum(String enumName, int occurrence) {
        for (JavaResourceEnum enum_ : this.getEnums()) {
            if (!enum_.isFor(enumName, occurrence)) continue;
            return enum_;
        }
        return null;
    }

    private void addEnum(JavaResourceEnum enum_) {
        this.addItemToCollection(enum_, this.enums, "enums");
    }

    private void removeEnums(Collection<JavaResourceEnum> remove) {
        this.removeItemsFromCollection(remove, this.enums, "enums");
    }

    private void initializeEnums(CompilationUnit astRoot) {
        EnumDeclaration[] enumDeclarations = ((Type)this.annotatedElement).getEnums(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(enumDeclarations.length);
        EnumDeclaration[] enumDeclarationArray = enumDeclarations;
        int n = enumDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDeclaration ed = enumDeclarationArray[n2];
            String tdName = ed.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.enums.add(this.buildEnum(ed, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncEnums(CompilationUnit astRoot) {
        EnumDeclaration[] enumDeclarations = ((Type)this.annotatedElement).getEnums(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(enumDeclarations.length);
        HashSet<JavaResourceEnum> enumsToRemove = new HashSet<JavaResourceEnum>(this.enums);
        EnumDeclaration[] enumDeclarationArray = enumDeclarations;
        int n = enumDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            EnumDeclaration enumDeclaration = enumDeclarationArray[n2];
            String tdName = enumDeclaration.getName().getFullyQualifiedName();
            JavaResourceEnum enum_ = this.getEnum(tdName, occurrence = counters.increment(tdName));
            if (enum_ == null) {
                this.addEnum(this.buildEnum(enumDeclaration, occurrence, astRoot));
            } else {
                enumsToRemove.remove(enum_);
                enum_.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeEnums(enumsToRemove);
    }

    private JavaResourceEnum buildEnum(EnumDeclaration nestedEnumDeclaration, int occurrence, CompilationUnit astRoot) {
        return SourceEnum.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.annotatedElement, nestedEnumDeclaration, occurrence, astRoot);
    }

    @Override
    public Iterable<JavaResourceField> getFields() {
        return new LiveCloneIterable(this.fields);
    }

    private void addField(JavaResourceField field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourceField getField(String fieldName, int occurrence) {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourceField> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private void initializeFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.annotatedElement).getFields(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(fieldDeclarations.length);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourceType.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, astRoot));
            }
            ++n2;
        }
    }

    private void syncFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.annotatedElement).getFields(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(fieldDeclarations.length);
        HashSet<JavaResourceField> fieldsToRemove = new HashSet<JavaResourceField>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourceType.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourceField field = this.getField(fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, astRoot));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    private JavaResourceField buildField(String fieldName, int occurrence, CompilationUnit astRoot) {
        return SourceField.newInstance(this, (Type)this.annotatedElement, fieldName, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    private static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    @Override
    public Iterable<JavaResourceMethod> getMethods() {
        return new LiveCloneIterable(this.methods);
    }

    private JavaResourceMethod getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourceMethod method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourceMethod> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private void initializeMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.annotatedElement).getMethods(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(methodDeclarations.length);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature((MethodDeclaration)methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.annotatedElement).getMethods(astRoot);
        SourceAbstractType.CounterMap counters = new SourceAbstractType.CounterMap(methodDeclarations.length);
        HashSet<JavaResourceMethod> methodsToRemove = new HashSet<JavaResourceMethod>(this.methods);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature((MethodDeclaration)methodDeclaration);
            JavaResourceMethod method = this.getMethod(signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, astRoot));
            } else {
                methodsToRemove.remove(method);
                method.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    private JavaResourceMethod buildMethod(MethodSignature signature, int occurrence, CompilationUnit astRoot) {
        return SourceMethod.newInstance(this, (Type)this.annotatedElement, signature, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }
}

