/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.AbstractJavaResourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.NestableAnnotation;

public abstract class SourceNode
extends AbstractJavaResourceNode {
    public SourceNode(JavaResourceNode parent) {
        super(parent);
    }

    public JavaResourceCompilationUnit getJavaResourceCompilationUnit() {
        return (JavaResourceCompilationUnit)this.getRoot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AnnotationContainer<T extends NestableAnnotation> {
        protected final Vector<T> nestedAnnotations = new Vector();

        protected AnnotationContainer() {
        }

        protected abstract String getElementName();

        protected abstract String getNestedAnnotationName();

        protected abstract T buildNestedAnnotation(int var1);

        protected abstract void fireItemAdded(int var1, T var2);

        protected abstract void fireItemsRemoved(int var1, List<T> var2);

        protected void initialize(Annotation astContainerAnnotation) {
            int size = this.getNestedAstAnnotations(astContainerAnnotation).size();
            int i = 0;
            while (i < size) {
                T nestedAnnotation = this.buildNestedAnnotation(i);
                this.nestedAnnotations.add(i, nestedAnnotation);
                nestedAnnotation.initialize((CompilationUnit)astContainerAnnotation.getRoot());
                ++i;
            }
        }

        protected void synchronize(Annotation astContainerAnnotation) {
            ArrayList<Annotation> astAnnotations = this.getNestedAstAnnotations(astContainerAnnotation);
            Iterator<Annotation> astAnnotationStream = astAnnotations.iterator();
            for (NestableAnnotation nestedAnnotation : this.getNestedAnnotations()) {
                if (astAnnotationStream.hasNext()) {
                    astAnnotationStream.next();
                    nestedAnnotation.synchronizeWith((CompilationUnit)astContainerAnnotation.getRoot());
                    continue;
                }
                this.syncRemoveNestedAnnotations(astAnnotations.size());
                return;
            }
            while (astAnnotationStream.hasNext()) {
                this.syncAddNestedAnnotation(astAnnotationStream.next());
            }
        }

        public ListIterable<T> getNestedAnnotations() {
            return new LiveCloneListIterable(this.nestedAnnotations);
        }

        public int getNestedAnnotationsSize() {
            return this.nestedAnnotations.size();
        }

        public T nestedAnnotationAt(int index) {
            return (T)((NestableAnnotation)this.nestedAnnotations.get(index));
        }

        public T addNestedAnnotation(int index) {
            int sourceIndex = this.getNestedAnnotationsSize();
            T nestedAnnotation = this.buildNestedAnnotation(sourceIndex);
            this.nestedAnnotations.add(sourceIndex, nestedAnnotation);
            nestedAnnotation.newAnnotation();
            this.moveNestedAnnotation(index, sourceIndex);
            return nestedAnnotation;
        }

        public T moveNestedAnnotation(int targetIndex, int sourceIndex) {
            if (targetIndex != sourceIndex) {
                return this.moveNestedAnnotation_(targetIndex, sourceIndex);
            }
            return null;
        }

        public T removeNestedAnnotation(int index) {
            NestableAnnotation nestedAnnotation = (NestableAnnotation)this.nestedAnnotations.remove(index);
            nestedAnnotation.removeAnnotation();
            this.syncAstAnnotationsAfterRemove(index);
            return (T)nestedAnnotation;
        }

        private T moveNestedAnnotation_(int targetIndex, int sourceIndex) {
            NestableAnnotation nestedAnnotation = (NestableAnnotation)CollectionTools.move(this.nestedAnnotations, (int)targetIndex, (int)sourceIndex).get(targetIndex);
            this.syncAstAnnotationsAfterMove(targetIndex, sourceIndex, nestedAnnotation);
            return (T)nestedAnnotation;
        }

        private ArrayList<Annotation> getNestedAstAnnotations(Annotation astContainerAnnotation) {
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            if (astContainerAnnotation != null && !astContainerAnnotation.isMarkerAnnotation()) {
                MemberValuePair pair;
                if (astContainerAnnotation.isSingleMemberAnnotation()) {
                    if (this.getElementName().equals("value")) {
                        Expression ex = ((SingleMemberAnnotation)astContainerAnnotation).getValue();
                        this.addAstAnnotationsTo(ex, result);
                    }
                } else if (astContainerAnnotation.isNormalAnnotation() && (pair = this.getMemberValuePair((NormalAnnotation)astContainerAnnotation)) != null) {
                    this.addAstAnnotationsTo(pair.getValue(), result);
                }
            }
            return result;
        }

        private void addAstAnnotationsTo(Expression expression, ArrayList<Annotation> astAnnotations) {
            if (expression != null) {
                if (expression.getNodeType() == 4) {
                    this.addAstAnnotationsTo((ArrayInitializer)expression, astAnnotations);
                } else {
                    Annotation astAnnotation = this.getAstAnnotation_(expression);
                    if (astAnnotation != null) {
                        astAnnotations.add(astAnnotation);
                    }
                }
            }
        }

        private void addAstAnnotationsTo(ArrayInitializer arrayInitializer, ArrayList<Annotation> astAnnotations) {
            List<Expression> expressions = this.expressions(arrayInitializer);
            for (Expression expression : expressions) {
                Annotation astAnnotation = this.getAstAnnotation(expression);
                if (astAnnotation == null) continue;
                astAnnotations.add(astAnnotation);
            }
        }

        private List<Expression> expressions(ArrayInitializer arrayInitializer) {
            return arrayInitializer.expressions();
        }

        private Annotation getAstAnnotation(Expression expression) {
            return expression == null ? null : this.getAstAnnotation_(expression);
        }

        private Annotation getAstAnnotation_(Expression expression) {
            switch (expression.getNodeType()) {
                case 77: 
                case 78: 
                case 79: {
                    Annotation astAnnotation = (Annotation)expression;
                    if (this.getQualifiedName(astAnnotation).equals(this.getNestedAnnotationName())) {
                        return astAnnotation;
                    }
                    return null;
                }
            }
            return null;
        }

        private String getQualifiedName(Annotation astAnnotation) {
            String resolvedName;
            ITypeBinding typeBinding = astAnnotation.resolveTypeBinding();
            if (typeBinding != null && (resolvedName = typeBinding.getQualifiedName()) != null) {
                return resolvedName;
            }
            return astAnnotation.getTypeName().getFullyQualifiedName();
        }

        private MemberValuePair getMemberValuePair(NormalAnnotation annotation) {
            List<MemberValuePair> pairs = this.values(annotation);
            for (MemberValuePair pair : pairs) {
                if (!pair.getName().getFullyQualifiedName().equals(this.getElementName())) continue;
                return pair;
            }
            return null;
        }

        protected List<MemberValuePair> values(NormalAnnotation na) {
            return na.values();
        }

        private void syncAstAnnotationsAfterMove(int targetIndex, int sourceIndex, T nestedAnnotation) {
            nestedAnnotation.moveAnnotation(this.getNestedAnnotationsSize());
            if (sourceIndex < targetIndex) {
                int i = sourceIndex;
                while (i < targetIndex) {
                    ((NestableAnnotation)this.nestedAnnotations.get(i)).moveAnnotation(i);
                    ++i;
                }
            } else {
                int i = sourceIndex;
                while (i > targetIndex) {
                    ((NestableAnnotation)this.nestedAnnotations.get(i)).moveAnnotation(i);
                    --i;
                }
            }
            nestedAnnotation.moveAnnotation(targetIndex);
        }

        private void syncAstAnnotationsAfterRemove(int index) {
            int i = index;
            while (i < this.getNestedAnnotationsSize()) {
                ((NestableAnnotation)this.nestedAnnotations.get(i)).moveAnnotation(i);
                ++i;
            }
        }

        protected void syncAddNestedAnnotation(Annotation astAnnotation) {
            int index = this.getNestedAnnotationsSize();
            T nestedAnnotation = this.buildNestedAnnotation(index);
            nestedAnnotation.initialize((CompilationUnit)astAnnotation.getRoot());
            this.nestedAnnotations.add(index, nestedAnnotation);
            this.fireItemAdded(index, nestedAnnotation);
        }

        protected void syncRemoveNestedAnnotations(int index) {
            List<T> subList = this.nestedAnnotations.subList(index, this.getNestedAnnotationsSize());
            ArrayList<T> removedItems = new ArrayList<T>(subList);
            subList.clear();
            this.fireItemsRemoved(index, removedItems);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

