/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.CommandExecutor;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceMethod
extends SourceAttribute<MethodAttribute>
implements JavaResourceMethod {
    boolean constructor;
    private final Vector<String> parameterTypeNames = new Vector();

    static JavaResourceMethod newInstance(JavaResourceType parent, Type declaringType, MethodSignature signature, int occurrence, JavaResourceCompilationUnit javaResourceCompilationUnit, CompilationUnit astRoot) {
        JDTMethodAttribute method = JDTMethodAttribute.newInstance((Type)declaringType, (MethodSignature)signature, (int)occurrence, (ICompilationUnit)javaResourceCompilationUnit.getCompilationUnit(), (CommandExecutor)javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), (AnnotationEditFormatter)javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceMethod jrm = new SourceMethod(parent, (MethodAttribute)method);
        jrm.initialize(astRoot);
        return jrm;
    }

    private SourceMethod(JavaResourceType parent, MethodAttribute method) {
        super(parent, method);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        IMethodBinding binding = ((MethodAttribute)this.annotatedElement).getBinding(astRoot);
        this.constructor = this.buildConstructor(binding);
        this.parameterTypeNames.addAll(this.buildParameterTypeNames(binding));
    }

    @Override
    protected JavaResourceType getParent() {
        return (JavaResourceType)super.getParent();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        IMethodBinding binding = ((MethodAttribute)this.annotatedElement).getBinding(astRoot);
        this.syncConstructor(this.buildConstructor(binding));
        this.syncParameterTypeNames(this.buildParameterTypeNames(binding));
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getMethodName());
    }

    @Override
    public String getMethodName() {
        return ((MethodAttribute)this.annotatedElement).getName();
    }

    @Override
    public boolean isConstructor() {
        return this.constructor;
    }

    private void syncConstructor(boolean astConstructor) {
        boolean old = this.constructor;
        this.constructor = astConstructor;
        this.firePropertyChanged("constructor", old, astConstructor);
    }

    private boolean buildConstructor(IMethodBinding methodBinding) {
        return methodBinding == null ? false : methodBinding.isConstructor();
    }

    @Override
    public boolean isFor(MethodSignature signature, int occurrence) {
        return ((MethodAttribute)this.annotatedElement).matches(signature, occurrence);
    }

    @Override
    public ListIterable<String> getParameterTypeNames() {
        return new LiveCloneListIterable(this.parameterTypeNames);
    }

    @Override
    public int getParametersSize() {
        return this.parameterTypeNames.size();
    }

    private void syncParameterTypeNames(List<String> astParameterTypeNames) {
        this.synchronizeList(astParameterTypeNames, this.parameterTypeNames, "parameterTypeNames");
    }

    private List<String> buildParameterTypeNames(IMethodBinding methodBinding) {
        if (methodBinding == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        ITypeBinding[] iTypeBindingArray = methodBinding.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding parameterType = iTypeBindingArray[n2];
            if (parameterType.isTypeVariable()) {
                parameterType = parameterType.getErasure();
            }
            String ptName = parameterType.getTypeDeclaration().getQualifiedName();
            names.add(ptName);
            ++n2;
        }
        return names;
    }
}

