/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.Annotation;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jaxb.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAnnotatedElement<A extends AnnotatedElement>
extends SourceNode
implements JavaResourceAnnotatedElement {
    final A annotatedElement;
    final Vector<Annotation> annotations = new Vector();
    final Map<String, AnnotationContainer> annotationContainers = new HashMap<String, AnnotationContainer>();

    SourceAnnotatedElement(JavaResourceNode parent, A annotatedElement) {
        super(parent);
        this.annotatedElement = annotatedElement;
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        ASTNode node = this.annotatedElement.getBodyDeclaration(astRoot);
        node.accept(this.buildInitialAnnotationVisitor(node));
    }

    private ASTVisitor buildInitialAnnotationVisitor(ASTNode node) {
        return new InitialAnnotationVisitor(node);
    }

    void addInitialAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
        String jdtAnnotationName = ASTTools.resolveAnnotation((org.eclipse.jdt.core.dom.Annotation)node);
        if (jdtAnnotationName != null) {
            if (this.annotationIsValid(jdtAnnotationName)) {
                if (this.selectAnnotationNamed(this.annotations, jdtAnnotationName) == null) {
                    Annotation annotation = this.buildAnnotation(jdtAnnotationName);
                    annotation.initialize((CompilationUnit)node.getRoot());
                    this.annotations.add(annotation);
                }
            } else if (this.annotationIsValidNestable(jdtAnnotationName)) {
                AnnotationContainer container = new AnnotationContainer(jdtAnnotationName);
                container.initializeNestableAnnotation(node);
                this.annotationContainers.put(jdtAnnotationName, container);
            } else if (this.annotationIsValidContainer(jdtAnnotationName)) {
                String nestableAnnotationName = this.getNestableAnnotationName(jdtAnnotationName);
                AnnotationContainer container = new AnnotationContainer(nestableAnnotationName);
                container.initialize(node);
                this.annotationContainers.put(nestableAnnotationName, container);
            }
        }
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncAnnotations(this.annotatedElement.getBodyDeclaration(astRoot));
    }

    @Override
    public Iterable<Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations);
    }

    @Override
    public int getAnnotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.buildNullAnnotation(annotationName);
    }

    public ListIterable<NestableAnnotation> getAnnotations(String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container != null ? container.getNestedAnnotations() : EmptyListIterable.instance();
    }

    @Override
    public int getAnnotationsSize(String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? 0 : container.getNestedAnnotationsSize();
    }

    @Override
    public NestableAnnotation getAnnotation(int index, String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? null : (NestableAnnotation)container.nestedAnnotationAt(index);
    }

    private String getNestableAnnotationName(String containerAnnotationName) {
        return this.getAnnotationProvider().getNestableAnnotationName(containerAnnotationName);
    }

    private String getNestableElementName(String nestableAnnotationName) {
        return this.getAnnotationProvider().getNestableElementName(nestableAnnotationName);
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        Annotation annotation = this.buildAnnotation(annotationName);
        this.annotations.add(annotation);
        annotation.newAnnotation();
        return annotation;
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        if (container == null) {
            container = new AnnotationContainer(nestableAnnotationName);
            this.annotationContainers.put(nestableAnnotationName, container);
        }
        return container.addNestedAnnotation(index);
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String nestableAnnotationName) {
        this.annotationContainers.get(nestableAnnotationName).moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        if (annotation != null) {
            this.removeAnnotation(annotation);
        }
    }

    private void removeAnnotation(Annotation annotation) {
        this.annotations.remove(annotation);
        annotation.removeAnnotation();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName) {
        this.annotationContainers.get(nestableAnnotationName).removeNestedAnnotation(index);
    }

    private boolean annotationIsValid(String annotationName) {
        return CollectionTools.contains(this.getValidAnnotationNames(), (Object)annotationName);
    }

    private boolean annotationIsValidContainer(String annotationName) {
        return CollectionTools.contains(this.getValidContainerAnnotationNames(), (Object)annotationName);
    }

    private boolean annotationIsValidNestable(String annotationName) {
        return CollectionTools.contains(this.getValidNestableAnnotationNames(), (Object)annotationName);
    }

    Iterable<String> getValidAnnotationNames() {
        return this.getAnnotationProvider().getAnnotationNames();
    }

    Iterable<String> getValidContainerAnnotationNames() {
        return this.getAnnotationProvider().getContainerAnnotationNames();
    }

    Iterable<String> getValidNestableAnnotationNames() {
        return this.getAnnotationProvider().getNestableAnnotationNames();
    }

    Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildAnnotation(this, (AnnotatedElement)this.annotatedElement, annotationName);
    }

    Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAnnotation(this, annotationName);
    }

    NestableAnnotation buildNestableAnnotation(String annotationName, int index) {
        return this.getAnnotationProvider().buildAnnotation(this, (AnnotatedElement)this.annotatedElement, annotationName, index);
    }

    private void syncAnnotations(ASTNode node) {
        HashSet<Annotation> annotationsToRemove = new HashSet<Annotation>(this.annotations);
        HashSet<AnnotationContainer> containersToRemove = new HashSet<AnnotationContainer>(this.annotationContainers.values());
        node.accept(this.buildSynchronizeAnnotationVisitor(node, annotationsToRemove, containersToRemove));
        for (Annotation annotation : annotationsToRemove) {
            this.removeItemFromCollection(annotation, this.annotations, "annotations");
        }
        for (AnnotationContainer annotationContainer : containersToRemove) {
            this.annotationContainers.remove(annotationContainer.getNestedAnnotationName());
            this.fireItemsRemoved("nestableAnnotations", (Collection)CollectionTools.collection(annotationContainer.getNestedAnnotations()));
        }
        Iterator<String> keys = this.annotationContainers.keySet().iterator();
        while (keys.hasNext()) {
            String annotationName = keys.next();
            if (this.annotationContainers.get(annotationName).getNestedAnnotationsSize() != 0) continue;
            keys.remove();
        }
    }

    private ASTVisitor buildSynchronizeAnnotationVisitor(ASTNode node, Set<Annotation> annotationsToRemove, Set<AnnotationContainer> containersToRemove) {
        return new SynchronizeAnnotationVisitor(node, annotationsToRemove, containersToRemove);
    }

    void addOrSyncAnnotation(org.eclipse.jdt.core.dom.Annotation node, Set<Annotation> annotationsToRemove, Set<AnnotationContainer> containersToRemove) {
        String jdtAnnotationName = ASTTools.resolveAnnotation((org.eclipse.jdt.core.dom.Annotation)node);
        if (jdtAnnotationName != null) {
            if (this.annotationIsValid(jdtAnnotationName)) {
                this.addOrSyncAnnotation_(node, jdtAnnotationName, annotationsToRemove);
            } else if (this.annotationIsValidNestable(jdtAnnotationName)) {
                this.addOrSyncNestableAnnotation_(node, jdtAnnotationName, containersToRemove);
            } else if (this.annotationIsValidContainer(jdtAnnotationName)) {
                this.addOrSyncContainerAnnotation_(node, jdtAnnotationName, containersToRemove);
            }
        }
    }

    private void addOrSyncAnnotation_(org.eclipse.jdt.core.dom.Annotation node, String jdtAnnotationName, Set<Annotation> annotationsToRemove) {
        Annotation annotation = this.selectAnnotationNamed(annotationsToRemove, jdtAnnotationName);
        if (annotation != null) {
            annotation.synchronizeWith((CompilationUnit)node.getRoot());
            annotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildAnnotation(jdtAnnotationName);
            annotation.initialize((CompilationUnit)node.getRoot());
            this.addItemToCollection(annotation, this.annotations, "annotations");
        }
    }

    private void addOrSyncNestableAnnotation_(org.eclipse.jdt.core.dom.Annotation node, String nestableAnnotationName, Set<AnnotationContainer> containersToRemove) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        if (container != null) {
            container.synchronizeNestableAnnotation(node);
            containersToRemove.remove(container);
        } else {
            container = new AnnotationContainer(nestableAnnotationName);
            container.initializeNestableAnnotation(node);
            this.annotationContainers.put(nestableAnnotationName, container);
            this.fireItemAdded("nestableAnnotations", container.nestedAnnotationAt(0));
        }
    }

    private void addOrSyncContainerAnnotation_(org.eclipse.jdt.core.dom.Annotation node, String containerAnnotationName, Set<AnnotationContainer> containersToRemove) {
        String nestableAnnotationName = this.getNestableAnnotationName(containerAnnotationName);
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        if (container == null) {
            container = new AnnotationContainer(nestableAnnotationName);
            container.initialize(node);
            this.annotationContainers.put(nestableAnnotationName, container);
            this.fireItemsAdded("nestableAnnotations", (Collection)CollectionTools.collection(container.getNestedAnnotations()));
        } else {
            container.synchronize(node);
            containersToRemove.remove(container);
        }
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty() || !this.annotationContainers.isEmpty();
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.fullTextRange(astRoot);
    }

    private TextRange fullTextRange(CompilationUnit astRoot) {
        return this.buildTextRange(this.annotatedElement.getBodyDeclaration(astRoot));
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.annotatedElement.getNameTextRange(astRoot);
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> list, String annotationName) {
        for (Annotation annotation : list) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    private TextRange buildTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationContainer
    extends SourceNode.AnnotationContainer<NestableAnnotation> {
        private final String nestableAnnotationName;

        protected AnnotationContainer(String nestableAnnotationName) {
            super(SourceAnnotatedElement.this);
            this.nestableAnnotationName = nestableAnnotationName;
        }

        @Override
        protected String getElementName() {
            return SourceAnnotatedElement.this.getNestableElementName(this.nestableAnnotationName);
        }

        @Override
        protected String getNestedAnnotationName() {
            return this.nestableAnnotationName;
        }

        @Override
        protected NestableAnnotation buildNestedAnnotation(int index) {
            return SourceAnnotatedElement.this.buildNestableAnnotation(this.nestableAnnotationName, index);
        }

        public void initializeNestableAnnotation(org.eclipse.jdt.core.dom.Annotation standaloneNestableAnnotation) {
            NestableAnnotation nestedAnnotation = this.buildNestedAnnotation(0);
            this.nestedAnnotations.add(nestedAnnotation);
            nestedAnnotation.initialize((CompilationUnit)standaloneNestableAnnotation.getRoot());
        }

        public void synchronizeNestableAnnotation(org.eclipse.jdt.core.dom.Annotation standaloneNestableAnnotation) {
            if (this.getNestedAnnotationsSize() <= 1 && this.getNestedAnnotationsSize() == 1) {
                this.nestedAnnotationAt(0).synchronizeWith((CompilationUnit)standaloneNestableAnnotation.getRoot());
            }
        }

        @Override
        protected void fireItemAdded(int index, NestableAnnotation nestedAnnotation) {
            SourceAnnotatedElement.this.fireItemAdded("nestableAnnotations", nestedAnnotation);
        }

        @Override
        protected void fireItemsRemoved(int index, List<NestableAnnotation> removedItems) {
            SourceAnnotatedElement.this.fireItemsRemoved("nestableAnnotations", removedItems);
        }
    }

    protected static abstract class AnnotationVisitor
    extends ASTVisitor {
        protected final ASTNode node;

        protected AnnotationVisitor(ASTNode node) {
            this.node = node;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(NormalAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(MarkerAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        protected boolean visit_(org.eclipse.jdt.core.dom.Annotation node) {
            if (node.getParent() == this.node) {
                this.visitChildAnnotation(node);
            }
            return false;
        }

        protected abstract void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InitialAnnotationVisitor
    extends AnnotationVisitor {
        protected InitialAnnotationVisitor(ASTNode node) {
            super(node);
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            SourceAnnotatedElement.this.addInitialAnnotation(node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SynchronizeAnnotationVisitor
    extends AnnotationVisitor {
        protected final Set<Annotation> annotationsToRemove;
        protected final Set<AnnotationContainer> containersToRemove;

        protected SynchronizeAnnotationVisitor(ASTNode node, Set<Annotation> annotationsToRemove, Set<AnnotationContainer> containersToRemove) {
            super(node);
            this.annotationsToRemove = annotationsToRemove;
            this.containersToRemove = containersToRemove;
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            SourceAnnotatedElement.this.addOrSyncAnnotation(node, this.annotationsToRemove, this.containersToRemove);
        }
    }
}

