/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.context.ui.AbstractContextLabelProvider;
import org.eclipse.mylyn.internal.context.ui.ContentOutlineManager;
import org.eclipse.mylyn.internal.context.ui.ContextEditorManager;
import org.eclipse.mylyn.internal.context.ui.ContextPerspectiveManager;
import org.eclipse.mylyn.internal.context.ui.ContextPopulationStrategy;
import org.eclipse.mylyn.internal.context.ui.FocusedViewerManager;
import org.eclipse.mylyn.internal.context.ui.wizards.RetrieveLatestContextDialog;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUiPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.context.ui";
    private final ContextActivationListener contextActivationListener = new ContextActivationListener();
    private final Map<String, AbstractContextUiBridge> bridges = new HashMap<String, AbstractContextUiBridge>();
    private final Map<String, ILabelProvider> contextLabelProviders = new HashMap<String, ILabelProvider>();
    private static ContextUiPlugin INSTANCE;
    private FocusedViewerManager viewerManager;
    private ContextPerspectiveManager perspectiveManager;
    private final ContentOutlineManager contentOutlineManager = new ContentOutlineManager();
    private final Map<AbstractContextUiBridge, ImageDescriptor> activeSearchIcons = new HashMap<AbstractContextUiBridge, ImageDescriptor>();
    private final Map<AbstractContextUiBridge, String> activeSearchLabels = new HashMap<AbstractContextUiBridge, String>();
    private final Map<String, Set<String>> preservedFilterClasses = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> preservedFilterIds = new HashMap<String, Set<String>>();
    private final ContextPopulationStrategy contextPopulationStrategy = new ContextPopulationStrategy();
    private static final AbstractContextLabelProvider DEFAULT_LABEL_PROVIDER;
    private static final AbstractContextUiBridge DEFAULT_UI_BRIDGE;
    private static final ITaskActivationListener TASK_ACTIVATION_LISTENER;
    private final AtomicBoolean lazyStarted = new AtomicBoolean(false);
    private ContextEditorManager editorManager;

    static {
        DEFAULT_LABEL_PROVIDER = new AbstractContextLabelProvider(){

            protected Image getImage(IInteractionElement node) {
                return null;
            }

            protected Image getImage(IInteractionRelation edge) {
                return null;
            }

            protected String getText(IInteractionElement node) {
                return "? " + node;
            }

            protected String getText(IInteractionRelation edge) {
                return "? " + edge;
            }

            protected Image getImageForObject(Object object) {
                return null;
            }

            protected String getTextForObject(Object node) {
                return "? " + node;
            }
        };
        DEFAULT_UI_BRIDGE = new AbstractContextUiBridge(){

            @Override
            public void open(IInteractionElement node) {
            }

            @Override
            public void close(IInteractionElement node) {
            }

            @Override
            public boolean acceptsEditor(IEditorPart editorPart) {
                return false;
            }

            @Override
            public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
                return Collections.emptyList();
            }

            @Override
            public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
                return null;
            }

            @Override
            public IInteractionElement getElement(IEditorInput input) {
                return null;
            }

            @Override
            public String getContentType() {
                return null;
            }
        };
        TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

            public void taskActivated(ITask task) {
                if (CoreUtil.TEST_MODE) {
                    return;
                }
                boolean hasLocalContext = ContextCore.getContextManager().hasContext(task.getHandleIdentifier());
                if (!hasLocalContext && AttachmentUtil.hasContextAttachment((ITask)task)) {
                    RetrieveLatestContextDialog.openQuestion(WorkbenchUtil.getShell(), task);
                }
            }
        };
    }

    public ContextUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs(this.getPreferenceStore());
        this.viewerManager = new FocusedViewerManager();
        this.perspectiveManager = new ContextPerspectiveManager(this.getPreferenceStore());
        this.editorManager = new ContextEditorManager();
        ContextCore.getContextManager().addListener((AbstractContextListener)this.contextActivationListener);
        if (ContextCore.getContextManager().isContextActive()) {
            this.initLazyStart();
        }
    }

    private void initLazyStart() {
        if (!this.lazyStarted.getAndSet(true)) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                this.lazyStart(workbench);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, super.getBundle().getSymbolicName(), 4, "Could not lazy start context plug-in", t));
            }
        }
    }

    private void lazyStart(IWorkbench workbench) {
        try {
            ContextCore.getContextManager().addListener((AbstractContextListener)this.viewerManager);
            MonitorUi.addWindowPartListener((IPartListener)this.contentOutlineManager);
            this.perspectiveManager.addManagedPerspective("org.eclipse.mylyn.tasks.ui.perspectives.planning");
            TasksUi.getTaskActivityManager().addActivationListener((ITaskActivationListener)this.perspectiveManager);
            MonitorUi.addWindowPerspectiveListener((IPerspectiveListener)this.perspectiveManager);
            TasksUi.getTaskActivityManager().addActivationListener(TASK_ACTIVATION_LISTENER);
            ContextCore.getContextManager().addListener((AbstractContextListener)this.editorManager);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Context UI initialization failed", (Throwable)e));
        }
        UiStartupExtensionPointReader.runStartupExtensions();
        try {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                if (window.getActivePage() != null) {
                    IViewReference[] views;
                    IViewReference[] iViewReferenceArray = views = window.getActivePage().getViewReferences();
                    int n3 = views.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewReference viewReference = iViewReferenceArray[n4];
                        IViewPart viewPart = viewReference.getView(false);
                        if (viewPart != null) {
                            FocusedViewerManager.initializeViewerSelection((IWorkbenchPart)viewPart);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            this.viewerManager.forceRefresh();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not initialize focused viewers", (Throwable)e));
        }
    }

    private void lazyStop() {
        if (this.editorManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.editorManager);
        }
        ContextCore.getContextManager().removeListener((AbstractContextListener)this.viewerManager);
        MonitorUi.removeWindowPartListener((IPartListener)this.contentOutlineManager);
        TasksUi.getTaskActivityManager().removeActivationListener((ITaskActivationListener)this.perspectiveManager);
        MonitorUi.removeWindowPerspectiveListener((IPerspectiveListener)this.perspectiveManager);
        TasksUi.getTaskActivityManager().removeActivationListener(TASK_ACTIVATION_LISTENER);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.lazyStarted.get()) {
            this.lazyStop();
        }
        if (TasksUi.getTaskActivityManager() != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.contextActivationListener);
        }
        super.stop(context);
        this.perspectiveManager.removeManagedPerspective("org.eclipse.mylyn.tasks.ui.perspectives.planning");
        this.viewerManager.dispose();
    }

    private void initDefaultPrefs(IPreferenceStore store) {
        store.setDefault("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable", true);
        store.setDefault("org.eclipse.mylyn.ide.ui.perspectives.auto.manage", false);
        store.setDefault("org.eclipse.mylyn.context.ui.editors.auto.manage", true);
        store.setDefault("org.eclipse.mylyn.ide.ui.expansion.auto.manage", true);
        store.setDefault("org.eclipse.mylyn.context.ui.close.action.manage", false);
        store.setDefault("org.eclipse.mylyn.context.ui.close.action.manage.warning", true);
    }

    public static ContextUiPlugin getDefault() {
        return INSTANCE;
    }

    @Deprecated
    public static String getResourceString(String key) {
        ResourceBundle bundle = ContextUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    @Deprecated
    public static String getMessage(String key) {
        ResourceBundle bundle = ContextUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    @Deprecated
    public ResourceBundle getResourceBundle() {
        return null;
    }

    public List<AbstractContextUiBridge> getUiBridges() {
        UiExtensionPointReader.initExtensions();
        return new ArrayList<AbstractContextUiBridge>(this.bridges.values());
    }

    public AbstractContextUiBridge getUiBridge(String contentType) {
        UiExtensionPointReader.initExtensions();
        AbstractContextUiBridge bridge = this.bridges.get(contentType);
        if (bridge != null) {
            return bridge;
        }
        return DEFAULT_UI_BRIDGE;
    }

    public AbstractContextUiBridge getUiBridgeForEditor(IEditorPart editorPart) {
        UiExtensionPointReader.initExtensions();
        AbstractContextUiBridge foundBridge = null;
        for (AbstractContextUiBridge bridge : this.bridges.values()) {
            if (!bridge.acceptsEditor(editorPart)) continue;
            foundBridge = bridge;
            break;
        }
        if (foundBridge != null) {
            return foundBridge;
        }
        return DEFAULT_UI_BRIDGE;
    }

    private void internalAddBridge(String extension, AbstractContextUiBridge bridge) {
        this.bridges.put(extension, bridge);
    }

    public ILabelProvider getContextLabelProvider(String extension) {
        ILabelProvider provider = this.contextLabelProviders.get(extension);
        if (provider != null) {
            return provider;
        }
        return DEFAULT_LABEL_PROVIDER;
    }

    private void internalAddContextLabelProvider(String extension, ILabelProvider provider) {
        this.contextLabelProviders.put(extension, provider);
    }

    public static FocusedViewerManager getViewerManager() {
        return ContextUiPlugin.INSTANCE.viewerManager;
    }

    private void setActiveSearchIcon(AbstractContextUiBridge bridge, ImageDescriptor descriptor) {
        this.activeSearchIcons.put(bridge, descriptor);
    }

    public ImageDescriptor getActiveSearchIcon(AbstractContextUiBridge bridge) {
        UiExtensionPointReader.initExtensions();
        return this.activeSearchIcons.get(bridge);
    }

    private void setActiveSearchLabel(AbstractContextUiBridge bridge, String label) {
        this.activeSearchLabels.put(bridge, label);
    }

    public String getActiveSearchLabel(AbstractContextUiBridge bridge) {
        UiExtensionPointReader.initExtensions();
        return this.activeSearchLabels.get(bridge);
    }

    public void addPreservedFilterClass(String viewId, String filterClass) {
        Set<String> preservedList = this.preservedFilterClasses.get(viewId);
        if (preservedList == null) {
            preservedList = new HashSet<String>();
            this.preservedFilterClasses.put(viewId, preservedList);
        }
        preservedList.add(filterClass);
    }

    public Set<String> getPreservedFilterClasses(String viewId) {
        UiExtensionPointReader.initExtensions();
        if (this.preservedFilterClasses.containsKey(viewId)) {
            return this.preservedFilterClasses.get(viewId);
        }
        return Collections.emptySet();
    }

    public void addPreservedFilterId(String viewId, String filterId) {
        Set<String> preservedList = this.preservedFilterIds.get(viewId);
        if (preservedList == null) {
            preservedList = new HashSet<String>();
            this.preservedFilterIds.put(viewId, preservedList);
        }
        preservedList.add(filterId);
    }

    public Set<String> getPreservedFilterIds(String viewId) {
        UiExtensionPointReader.initExtensions();
        if (this.preservedFilterIds.containsKey(viewId)) {
            return this.preservedFilterIds.get(viewId);
        }
        return Collections.emptySet();
    }

    public static ContextEditorManager getEditorManager() {
        return ContextUiPlugin.INSTANCE.editorManager;
    }

    public static ContextPerspectiveManager getPerspectiveManager() {
        return ContextUiPlugin.INSTANCE.perspectiveManager;
    }

    private class ContextActivationListener
    extends AbstractContextListener {
        private ContextActivationListener() {
        }

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case PRE_ACTIVATED: {
                    ContextUiPlugin.this.initLazyStart();
                    ContextUiPlugin.this.contextPopulationStrategy.activated(event);
                }
            }
        }
    }

    static class UiExtensionPointReader {
        private static boolean extensionsRead = false;
        public static final String EXTENSION_ID_CONTEXT = "org.eclipse.mylyn.context.ui.bridges";
        public static final String ELEMENT_UI_BRIDGE = "uiBridge";
        public static final String ELEMENT_PRESERVED_FILTERS = "preservedFilters";
        public static final String ELEMENT_VIEW_ID = "viewId";
        public static final String ELEMENT_ID = "id";
        public static final String ELEMENT_FILTER = "filter";
        public static final String ELEMENT_CLASS = "class";
        public static final String ELEMENT_UI_CONTEXT_LABEL_PROVIDER = "labelProvider";
        public static final String ELEMENT_UI_BRIDGE_CONTENT_TYPE = "contentType";
        public static final String ELEMENT_STRUCTURE_BRIDGE_SEARCH_ICON = "activeSearchIcon";
        public static final String ELEMENT_STRUCTURE_BRIDGE_SEARCH_LABEL = "activeSearchLabel";

        UiExtensionPointReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IExtension[] extensions;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CONTEXT);
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (element.getName().equals(ELEMENT_UI_BRIDGE)) {
                            UiExtensionPointReader.readBridge(element);
                        } else if (element.getName().equals(ELEMENT_UI_CONTEXT_LABEL_PROVIDER)) {
                            UiExtensionPointReader.readLabelProvider(element);
                        } else if (element.getName().equals(ELEMENT_PRESERVED_FILTERS)) {
                            UiExtensionPointReader.readPreservedFilters(element);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                extensionsRead = true;
            }
        }

        private static void readLabelProvider(IConfigurationElement element) {
            try {
                Object provider = element.createExecutableExtension(ELEMENT_CLASS);
                String contentType = element.getAttribute(ELEMENT_UI_BRIDGE_CONTENT_TYPE);
                if (provider instanceof ILabelProvider && contentType != null) {
                    ContextUiPlugin.getDefault().internalAddContextLabelProvider(contentType, (ILabelProvider)provider);
                } else {
                    StatusHandler.log((IStatus)new Status(4, ContextUiPlugin.ID_PLUGIN, "Could not load label provider: " + provider.getClass().getCanonicalName() + " must implement " + ILabelProvider.class.getCanonicalName()));
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, ContextUiPlugin.ID_PLUGIN, "Could not load label provider extension", (Throwable)e));
            }
        }

        private static void readPreservedFilters(IConfigurationElement element) {
            IConfigurationElement[] children;
            String viewId = element.getAttribute(ELEMENT_VIEW_ID);
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals(ELEMENT_FILTER)) {
                    try {
                        String filterId = child.getAttribute(ELEMENT_ID);
                        ContextUiPlugin.getDefault().addPreservedFilterId(viewId, filterId);
                        String filterClass = child.getAttribute(ELEMENT_CLASS);
                        ContextUiPlugin.getDefault().addPreservedFilterClass(viewId, filterClass);
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }

        private static void readBridge(IConfigurationElement element) {
            try {
                Object bridge = element.createExecutableExtension(ELEMENT_CLASS);
                String contentType = element.getAttribute(ELEMENT_UI_BRIDGE_CONTENT_TYPE);
                if (bridge instanceof AbstractContextUiBridge && contentType != null) {
                    String label;
                    ImageDescriptor descriptor;
                    ContextUiPlugin.getDefault().internalAddBridge(contentType, (AbstractContextUiBridge)bridge);
                    String iconPath = element.getAttribute(ELEMENT_STRUCTURE_BRIDGE_SEARCH_ICON);
                    if (iconPath != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getDeclaringExtension().getContributor().getName(), (String)iconPath)) != null) {
                        ContextUiPlugin.getDefault().setActiveSearchIcon((AbstractContextUiBridge)bridge, descriptor);
                    }
                    if ((label = element.getAttribute(ELEMENT_STRUCTURE_BRIDGE_SEARCH_LABEL)) != null) {
                        ContextUiPlugin.getDefault().setActiveSearchLabel((AbstractContextUiBridge)bridge, label);
                    }
                } else {
                    StatusHandler.log((IStatus)new Status(4, ContextUiPlugin.ID_PLUGIN, "Could not load bridge: " + bridge.getClass().getCanonicalName() + " must implement " + AbstractContextUiBridge.class.getCanonicalName()));
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, ContextUiPlugin.ID_PLUGIN, "Could not load bridge extension", (Throwable)e));
            }
        }
    }

    static class UiStartupExtensionPointReader {
        private static final String EXTENSION_ID_STARTUP = "org.eclipse.mylyn.context.ui.startup";
        private static final String ELEMENT_STARTUP = "startup";
        private static final String ELEMENT_CLASS = "class";

        UiStartupExtensionPointReader() {
        }

        public static void runStartupExtensions() {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_STARTUP);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().compareTo(ELEMENT_STARTUP) == 0) {
                        UiStartupExtensionPointReader.runStartupExtension(element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        private static void runStartupExtension(IConfigurationElement configurationElement) {
            try {
                Object object = WorkbenchPlugin.createExtension((IConfigurationElement)configurationElement, (String)ELEMENT_CLASS);
                if (!(object instanceof IContextUiStartup)) {
                    StatusHandler.log((IStatus)new Status(4, ContextUiPlugin.ID_PLUGIN, "Could not : " + object.getClass().getCanonicalName() + " must implement " + AbstractContextStructureBridge.class.getCanonicalName()));
                    return;
                }
                IContextUiStartup startup = (IContextUiStartup)object;
                startup.lazyStartup();
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, ContextUiPlugin.ID_PLUGIN, "Could not load startup extension", (Throwable)e));
            }
        }
    }
}

