/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlIdentifierMessages;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JpqlCompletionProposalComputer<T> {
    String actualQuery;
    ContentAssistProposals contentAssistProposals;
    private ImageRegistry imageRegistry;
    String jpqlQuery;
    NamedQuery namedQuery;
    int offset;
    private String partialWord;
    int position;
    final JpaJpqlQueryHelper queryHelper = new JpaJpqlQueryHelper();

    private void addAbstractSchemaNames(List<T> proposals) {
        for (IEntity abstractSchemaType : this.sortByNames(this.contentAssistProposals.abstractSchemaTypes())) {
            proposals.add(this.buildAbstractSchemaNameProposal(abstractSchemaType));
        }
    }

    private void addIdentificationVariables(List<T> proposals) {
        for (String variable : CollectionTools.sort((Iterable)this.contentAssistProposals.identificationVariables())) {
            proposals.add(this.buildIdentificationVariableProposal(variable));
        }
    }

    private void addIdentifiers(List<T> proposals) {
        for (String identifier : CollectionTools.sort((Iterable)this.contentAssistProposals.identifiers())) {
            proposals.add(this.buildIdentifierProposal(identifier));
        }
    }

    private String additionalInfo(String proposal) {
        return JpqlIdentifierMessages.localizedMessage(proposal);
    }

    private void addMappings(List<T> proposals) {
        for (IMapping mapping : CollectionTools.sort((Iterable)this.contentAssistProposals.mappings())) {
            proposals.add(this.buildMappingProposal(mapping));
        }
    }

    private T buildAbstractSchemaNameProposal(IEntity abstractSchemaType) {
        String proposal = abstractSchemaType.getName();
        return this.buildProposal(proposal, proposal, this.entityImage());
    }

    private Comparator<IEntity> buildEntityNameComparator() {
        return new Comparator<IEntity>(){

            @Override
            public int compare(IEntity entity1, IEntity entity2) {
                return entity1.getName().compareTo(entity2.getName());
            }
        };
    }

    private String buildIdentificationVariableDisplayString(String identificationVariable) {
        IEntity abstractSchemaType = this.contentAssistProposals.getAbstractSchemaType(identificationVariable);
        if (abstractSchemaType != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(identificationVariable);
            sb.append(" : ");
            sb.append(abstractSchemaType.getName());
            identificationVariable = sb.toString();
        }
        return identificationVariable;
    }

    private T buildIdentificationVariableProposal(String proposal) {
        return this.buildProposal(proposal, this.buildIdentificationVariableDisplayString(proposal), this.identificationVariableImage());
    }

    private T buildIdentifierProposal(String proposal) {
        String additionalInfo = this.additionalInfo(proposal);
        IdentifierRole role = JPQLExpression.identifierRole((String)proposal);
        boolean realFunction = role == IdentifierRole.FUNCTION && this.isRealFunction(proposal);
        int cursorOffset = 0;
        if (this.partialWord.length() > 0 && this.shouldMatchFirstCharacterCase()) {
            if (Character.isLowerCase(this.partialWord.charAt(0))) {
                proposal = proposal.toLowerCase();
            }
        } else if (this.shouldUseLowercaseIdentifiers()) {
            proposal = proposal.toLowerCase();
        }
        if (realFunction) {
            proposal = String.valueOf(proposal) + "()";
            --cursorOffset;
        }
        return this.buildProposal(proposal, proposal, additionalInfo, this.identifierImage(realFunction), cursorOffset);
    }

    private T buildMappingProposal(IMapping mapping) {
        String proposal = mapping.getName();
        return this.buildProposal(proposal, proposal, this.mappingImage(mapping));
    }

    private T buildProposal(String proposal, String displayString, Image image) {
        return this.buildProposal(proposal, displayString, null, image, 0);
    }

    abstract T buildProposal(String var1, String var2, String var3, Image var4, int var5);

    final List<T> buildProposals(NamedQuery namedQuery, String actualQuery, int offset, int position) {
        this.offset = offset;
        this.actualQuery = actualQuery;
        this.namedQuery = namedQuery;
        int[] positions = new int[]{position};
        this.jpqlQuery = this.modifyJpqlQuery(actualQuery, positions);
        this.position = positions[0];
        this.partialWord = this.partialWord();
        this.queryHelper.setQuery(namedQuery, this.jpqlQuery);
        this.contentAssistProposals = this.queryHelper.buildContentAssistProposals(positions[0]);
        this.queryHelper.dispose();
        ArrayList proposals = new ArrayList();
        this.addAbstractSchemaNames(proposals);
        this.addIdentificationVariables(proposals);
        this.addIdentifiers(proposals);
        this.addMappings(proposals);
        return proposals;
    }

    final void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    final void clearInformation() {
        this.offset = -1;
        this.position = -1;
        this.actualQuery = null;
        this.namedQuery = null;
        this.partialWord = null;
        this.contentAssistProposals = null;
    }

    private Image entityImage() {
        return this.getImage("full/obj16/entity");
    }

    public String getErrorMessage() {
        return null;
    }

    private Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(String key) {
        return JptJpaUiPlugin.getImageDescriptor(key);
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry(Display.getCurrent());
        }
        return this.imageRegistry;
    }

    private Image identificationVariableImage() {
        return this.getImage("full/obj16/jpql.variable");
    }

    private Image identifierImage(boolean function) {
        if (function) {
            return this.getImage("full/obj16/jpql.function");
        }
        return this.getImage("full/obj16/jpql.identifier");
    }

    private boolean isRealFunction(String identifier) {
        return identifier != "TRUE" && identifier != "FALSE" && identifier != "NULL" && identifier != "CURRENT_DATE" && identifier != "CURRENT_TIME" && identifier != "CURRENT_TIMESTAMP";
    }

    private Image mappingImage(IMapping mapping) {
        switch (mapping.getMappingType()) {
            case BASIC: {
                return this.getImage("full/obj16/basic");
            }
            case BASIC_COLLECTION: {
                return this.getImage("full/obj16/element-collection");
            }
            case BASIC_MAP: {
                return this.getImage("full/obj16/element-collection");
            }
            case ELEMENT_COLLECTION: {
                return this.getImage("full/obj16/element-collection");
            }
            case EMBEDDED: {
                return this.getImage("full/obj16/embedded");
            }
            case EMBEDDED_ID: {
                return this.getImage("full/obj16/embedded-id");
            }
            case ID: {
                return this.getImage("full/obj16/id");
            }
            case MANY_TO_MANY: {
                return this.getImage("full/obj16/many-to-many");
            }
            case MANY_TO_ONE: {
                return this.getImage("full/obj16/many-to-one");
            }
            case ONE_TO_MANY: {
                return this.getImage("full/obj16/one-to-many");
            }
            case ONE_TO_ONE: {
                return this.getImage("full/obj16/one-to-one");
            }
            case TRANSFORMATION: {
                return this.getImage("full/obj16/basic");
            }
            case VARIABLE_ONE_TO_ONE: {
                return this.getImage("full/obj16/one-to-one");
            }
            case VERSION: {
                return this.getImage("full/obj16/version");
            }
        }
        return this.getImage("full/obj16/transient");
    }

    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        return jpqlQuery;
    }

    private String partialWord() {
        WordParser wordParser = new WordParser((CharSequence)this.jpqlQuery);
        wordParser.setPosition(this.position);
        return wordParser.partialWord();
    }

    public void sessionEnded() {
        this.queryHelper.disposeProvider();
        this.clearInformation();
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
    }

    public void sessionStarted() {
    }

    private boolean shouldMatchFirstCharacterCase() {
        return JptJpaUiPlugin.instance().getPreferenceStore().getBoolean("org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase");
    }

    private boolean shouldUseLowercaseIdentifiers() {
        String value = JptJpaUiPlugin.instance().getPreferenceStore().getString("org.eclipse.jpt.jpa.ui.jpqlIdentifier.case");
        return "lowercase".equals(value);
    }

    private Iterable<IEntity> sortByNames(Iterable<IEntity> abstractSchemaTypes) {
        return CollectionTools.sort(abstractSchemaTypes, this.buildEntityNameComparator());
    }
}

