/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBooleanPropertyValueModel
extends CompositePropertyValueModel<Boolean> {
    protected final Adapter adapter;
    private final Boolean defaultValue;
    public static final Adapter AND_ADAPTER = new Adapter(){

        @Override
        public Boolean buildValue(Iterable<Boolean> booleans) {
            for (Boolean b : booleans) {
                if (b.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public String toString() {
            return "AND_ADAPTER";
        }
    };
    public static final Adapter OR_ADAPTER = new Adapter(){

        @Override
        public Boolean buildValue(Iterable<Boolean> booleans) {
            for (Boolean b : booleans) {
                if (!b.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String toString() {
            return "OR_ADAPTER";
        }
    };

    public static CompositeBooleanPropertyValueModel and(PropertyValueModel<Boolean> ... array) {
        return new CompositeBooleanPropertyValueModel(AND_ADAPTER, array);
    }

    public static CompositeBooleanPropertyValueModel and(Boolean defaultValue, PropertyValueModel<Boolean> ... array) {
        return new CompositeBooleanPropertyValueModel(AND_ADAPTER, defaultValue, array);
    }

    public static <E extends PropertyValueModel<Boolean>> CompositeBooleanPropertyValueModel and(Collection<E> collection) {
        return new CompositeBooleanPropertyValueModel(AND_ADAPTER, collection);
    }

    public static <E extends PropertyValueModel<Boolean>> CompositeBooleanPropertyValueModel and(Boolean defaultValue, Collection<E> collection) {
        return new CompositeBooleanPropertyValueModel(AND_ADAPTER, defaultValue, collection);
    }

    public static CompositeBooleanPropertyValueModel and(CollectionValueModel<? extends PropertyValueModel<Boolean>> collectionModel) {
        return new CompositeBooleanPropertyValueModel(AND_ADAPTER, collectionModel);
    }

    public static CompositeBooleanPropertyValueModel and(Boolean defaultValue, CollectionValueModel<? extends PropertyValueModel<Boolean>> collectionModel) {
        return new CompositeBooleanPropertyValueModel(AND_ADAPTER, defaultValue, collectionModel);
    }

    public static CompositeBooleanPropertyValueModel or(PropertyValueModel<Boolean> ... array) {
        return new CompositeBooleanPropertyValueModel(OR_ADAPTER, array);
    }

    public static CompositeBooleanPropertyValueModel or(Boolean defaultValue, PropertyValueModel<Boolean> ... array) {
        return new CompositeBooleanPropertyValueModel(OR_ADAPTER, defaultValue, array);
    }

    public static <E extends PropertyValueModel<Boolean>> CompositeBooleanPropertyValueModel or(Collection<E> collection) {
        return new CompositeBooleanPropertyValueModel(OR_ADAPTER, collection);
    }

    public static <E extends PropertyValueModel<Boolean>> CompositeBooleanPropertyValueModel or(Boolean defaultValue, Collection<E> collection) {
        return new CompositeBooleanPropertyValueModel(OR_ADAPTER, defaultValue, collection);
    }

    public static CompositeBooleanPropertyValueModel or(CollectionValueModel<? extends PropertyValueModel<Boolean>> collectionModel) {
        return new CompositeBooleanPropertyValueModel(OR_ADAPTER, collectionModel);
    }

    public static CompositeBooleanPropertyValueModel or(Boolean defaultValue, CollectionValueModel<? extends PropertyValueModel<Boolean>> collectionModel) {
        return new CompositeBooleanPropertyValueModel(OR_ADAPTER, defaultValue, collectionModel);
    }

    public CompositeBooleanPropertyValueModel(Adapter adapter, PropertyValueModel<Boolean> ... array) {
        this(adapter, (Boolean)null, array);
    }

    public CompositeBooleanPropertyValueModel(Adapter adapter, Boolean defaultValue, PropertyValueModel<Boolean> ... array) {
        super(array);
        this.adapter = adapter;
        this.defaultValue = defaultValue;
    }

    public <E extends PropertyValueModel<Boolean>> CompositeBooleanPropertyValueModel(Adapter adapter, Collection<E> collection) {
        this(adapter, null, collection);
    }

    public <E extends PropertyValueModel<Boolean>> CompositeBooleanPropertyValueModel(Adapter adapter, Boolean defaultValue, Collection<E> collection) {
        super(collection);
        this.adapter = adapter;
        this.defaultValue = defaultValue;
    }

    public CompositeBooleanPropertyValueModel(Adapter adapter, CollectionValueModel<? extends PropertyValueModel<Boolean>> collectionModel) {
        this(adapter, null, collectionModel);
    }

    public CompositeBooleanPropertyValueModel(Adapter adapter, Boolean defaultValue, CollectionValueModel<? extends PropertyValueModel<Boolean>> collectionModel) {
        super((CollectionValueModel<? extends PropertyValueModel<?>>)collectionModel);
        this.adapter = adapter;
        this.defaultValue = defaultValue;
    }

    @Override
    protected Boolean buildValue() {
        return this.collectionModel.size() == 0 ? this.defaultValue : this.buildValue_();
    }

    protected Boolean buildValue_() {
        return this.adapter.buildValue(this.getBooleans());
    }

    protected Iterable<Boolean> getBooleans() {
        return new TransformationIterable<PropertyValueModel<Boolean>, Boolean>(this.getCollectionModel()){

            @Override
            protected Boolean transform(PropertyValueModel<Boolean> booleanModel) {
                return booleanModel.getValue();
            }
        };
    }

    @Override
    protected CollectionValueModel<? extends PropertyValueModel<Boolean>> getCollectionModel() {
        return super.getCollectionModel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter {
        public Boolean buildValue(Iterable<Boolean> var1);
    }
}

