/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Filter<E> filter;
    private E next;
    private boolean done;

    public FilteringIterator(Iterable<? extends E> iterable) {
        this(iterable.iterator());
    }

    public FilteringIterator(Iterator<? extends E> iterator) {
        this(iterator, Filter.Disabled.instance());
    }

    public FilteringIterator(Iterable<? extends E> iterable, Filter<E> filter) {
        this(iterable.iterator(), filter);
    }

    public FilteringIterator(Iterator<? extends E> iterator, Filter<E> filter) {
        this.iterator = iterator;
        this.filter = filter;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.loadNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        this.done = true;
        while (this.iterator.hasNext() && this.done) {
            E temp = this.iterator.next();
            if (this.accept(temp)) {
                this.next = temp;
                this.done = false;
                continue;
            }
            this.next = null;
            this.done = true;
        }
    }

    protected boolean accept(E o) {
        return this.filter.accept(o);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterator);
    }
}

