/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterables;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> iterable;
    private final Filter<E> filter;

    public FilteringIterable(Iterable<? extends E> iterable) {
        this.iterable = iterable;
        this.filter = this.buildDefaultFilter();
    }

    public FilteringIterable(Iterable<? extends E> iterable, Filter<E> filter) {
        this.iterable = iterable;
        this.filter = filter;
    }

    protected Filter<E> buildDefaultFilter() {
        return new DefaultFilter();
    }

    @Override
    public Iterator<E> iterator() {
        return new FilteringIterator<E>(this.iterable.iterator(), this.filter);
    }

    protected boolean accept(E o) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultFilter
    implements Filter<E> {
        protected DefaultFilter() {
        }

        @Override
        public boolean accept(E o) {
            return FilteringIterable.this.accept(o);
        }
    }
}

