/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jpt.common.utility.internal.Queue;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleQueue<E>
implements Queue<E>,
Cloneable,
Serializable {
    private LinkedList<E> elements;
    private static final long serialVersionUID = 1L;

    public SimpleQueue() {
        this.elements = new LinkedList();
    }

    public SimpleQueue(Collection<? extends E> c) {
        this.elements = new LinkedList<E>(c);
    }

    @Override
    public void enqueue(E o) {
        this.elements.addLast(o);
    }

    @Override
    public E dequeue() {
        return this.elements.removeFirst();
    }

    @Override
    public E peek() {
        return this.elements.getFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public SimpleQueue<E> clone() {
        try {
            LinkedList ll;
            SimpleQueue clone = (SimpleQueue)super.clone();
            clone.elements = ll = (LinkedList)this.elements.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.peek());
    }
}

