/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.common.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedSet<K, V> {
    private final Set<V> itemSet = new HashSet<V>();
    private final Set<V> unmodifiableItemSet = Collections.unmodifiableSet(this.itemSet);
    private final Map<K, V> map = new HashMap();

    public Set<V> getItemSet() {
        return this.unmodifiableItemSet;
    }

    public V getItem(K key) {
        return this.map.get(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsItem(V item) {
        return this.itemSet.contains(item);
    }

    public void addItem(K key, V item) {
        this.addItem(item);
        this.addKey(key, item);
    }

    private void addItem(V item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        this.itemSet.add(item);
    }

    public void addKey(K key, V item) {
        if (key == null || item == null) {
            throw new IllegalArgumentException();
        }
        if (!this.itemSet.contains(item)) {
            throw new IllegalArgumentException();
        }
        this.map.put(key, item);
    }

    public boolean removeItem(V item) {
        if (this.itemSet.remove(item)) {
            for (Map.Entry<K, V> entry : CollectionTools.collection(this.map.entrySet())) {
                if (entry.getValue() != item) continue;
                this.map.remove(entry.getKey());
            }
            return true;
        }
        return false;
    }

    public boolean removeKey(K key) {
        V item = this.map.get(key);
        if (item != null) {
            this.map.remove(key);
            boolean otherKey = false;
            for (Map.Entry<K, V> entry : CollectionTools.collection(this.map.entrySet())) {
                if (!(otherKey | entry.getValue() == item)) continue;
                otherKey = true;
            }
            if (!otherKey) {
                this.removeItem(item);
            }
            return true;
        }
        return false;
    }
}

