/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkConversionValue
extends AbstractOrmXmlContextNode
implements EclipseLinkConversionValue {
    private final XmlConversionValue xmlConversionValue;
    private String dataValue;
    private String objectValue;

    public OrmEclipseLinkConversionValue(OrmEclipseLinkObjectTypeConverter parent, XmlConversionValue xmlConversionValue) {
        super((JpaContextNode)parent);
        this.xmlConversionValue = xmlConversionValue;
        this.dataValue = xmlConversionValue.getDataValue();
        this.objectValue = xmlConversionValue.getObjectValue();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataValue_(this.xmlConversionValue.getDataValue());
        this.setObjectValue_(this.xmlConversionValue.getObjectValue());
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String value) {
        this.setDataValue_(value);
        this.xmlConversionValue.setDataValue(value);
    }

    protected void setDataValue_(String value) {
        String old = this.dataValue;
        this.dataValue = value;
        this.firePropertyChanged("dataValue", old, value);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String value) {
        this.setObjectValue_(value);
        this.xmlConversionValue.setObjectValue(value);
    }

    protected void setObjectValue_(String value) {
        String old = this.objectValue;
        this.objectValue = value;
        this.firePropertyChanged("objectValue", old, value);
    }

    @Override
    public OrmEclipseLinkObjectTypeConverter getParent() {
        return (OrmEclipseLinkObjectTypeConverter)super.getParent();
    }

    protected OrmEclipseLinkObjectTypeConverter getObjectTypeConverter() {
        return this.getParent();
    }

    public XmlConversionValue getXmlConversionValue() {
        return this.xmlConversionValue;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateDataValuesUnique(messages);
    }

    protected void validateDataValuesUnique(List<IMessage> messages) {
        HashBag dataValues = CollectionTools.bag(this.getObjectTypeConverter().getDataValues(), (int)this.getObjectTypeConverter().getDataValuesSize());
        if (dataValues.count((Object)this.dataValue) > 1) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE", new String[]{this.dataValue}, this, this.getDataValueTextRange()));
        }
    }

    protected TextRange getDataValueTextRange() {
        return this.getValidationTextRange(this.xmlConversionValue.getDataValueTextRange());
    }

    protected TextRange getObjectValueTextRange() {
        return this.getValidationTextRange(this.xmlConversionValue.getObjectValueTextRange());
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlConversionValue.getValidationTextRange();
        return textRange != null ? textRange : this.getObjectTypeConverter().getValidationTextRange();
    }
}

