/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class ErrorRecoveryLog {
    private static final String ERROR_RECOVERY_LOG = "error_recovery.log";
    private static final String LOG_ENTRY_KEY = "LogEntry.";
    private static final String RETURN_CARRIAGE = "\r\n";
    private static final String END_OF_FILE = "eof=eof";
    public static final String START_INSTALL_LOG = "START_INSTALL_LOG";
    public static final String PLUGIN_ENTRY = "PLUGIN";
    public static final String FRAGMENT_ENTRY = "FRAGMENT";
    public static final String BUNDLE_MANIFEST_ENTRY = "BUNDLE_MANIFEST";
    public static final String BUNDLE_JAR_ENTRY = "BUNDLE";
    public static final String FEATURE_ENTRY = "FEATURE";
    public static final String ALL_INSTALLED = "ALL_FEATURES_INSTALLED";
    public static final String RENAME_ENTRY = "RENAME";
    public static final String END_INSTALL_LOG = "END_INSTALL_LOG";
    public static final String START_REMOVE_LOG = "REMOVE_LOG";
    public static final String END_ABOUT_REMOVE = "END_ABOUT_TO_REMOVE";
    public static final String DELETE_ENTRY = "DELETE";
    public static final String END_REMOVE_LOG = "END_REMOVE_LOG";
    private static ErrorRecoveryLog inst;
    private FileWriter out;
    private int index;
    private List paths;
    private boolean open = false;
    private int nbOfOpen = 0;

    private ErrorRecoveryLog() {
    }

    public static ErrorRecoveryLog getLog() {
        if (inst == null) {
            inst = new ErrorRecoveryLog();
        }
        return inst;
    }

    public static String getLocalRandomIdentifier(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(File.separator) || path.endsWith("/")) {
            return path;
        }
        File file = new File(path);
        String newName = UpdateManagerUtils.getLocalRandomIdentifier(file.getName(), new Date());
        while (new File(file.getParentFile(), newName).exists()) {
            newName = UpdateManagerUtils.getLocalRandomIdentifier(file.getName(), new Date());
        }
        File newFile = new File(file.getParentFile(), newName);
        return newFile.getAbsolutePath();
    }

    public File getRecoveryLogFile() {
        IPlatformConfiguration configuration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        URL location = configuration.getConfigurationLocation();
        String locationString = location.getFile();
        File platformConfiguration = new File(locationString);
        if (!platformConfiguration.isDirectory()) {
            platformConfiguration = platformConfiguration.getParentFile();
        }
        return new File(platformConfiguration, ERROR_RECOVERY_LOG);
    }

    public void open(String logEntry) throws CoreException {
        if (this.open) {
            ++this.nbOfOpen;
            UpdateCore.warn("Open nested Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
            return;
        }
        File logFile = null;
        try {
            logFile = this.getRecoveryLogFile();
            this.out = new FileWriter(logFile);
            this.index = 0;
            this.paths = null;
            this.open = true;
            this.nbOfOpen = 0;
            UpdateCore.warn("Start new Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
        }
        catch (IOException e) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.UpdateManagerUtils_UnableToLog, (Object[])new Object[]{logFile}), e);
        }
        this.append(logEntry);
    }

    public void append(String logEntry) throws CoreException {
        Object logFile = null;
        try {
            if (!this.open) {
                UpdateCore.warn("Internal Error: The Error/Recovery log is not open:" + logEntry);
                return;
            }
            StringBuffer buffer = new StringBuffer(LOG_ENTRY_KEY);
            buffer.append(this.index);
            buffer.append("=");
            buffer.append(logEntry);
            buffer.append(RETURN_CARRIAGE);
            this.out.write(buffer.toString());
            this.out.flush();
            ++this.index;
        }
        catch (IOException e) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.UpdateManagerUtils_UnableToLog, (Object[])new Object[]{logFile}), e);
        }
    }

    public void appendPath(String logEntry, String path) throws CoreException {
        if (path == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(logEntry);
        buffer.append(" ");
        buffer.append(path);
        this.append(buffer.toString());
        this.addPath(path);
    }

    public void close(String logEntry) throws CoreException {
        if (this.nbOfOpen > 0) {
            UpdateCore.warn("Close nested Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
            --this.nbOfOpen;
            return;
        }
        UpdateCore.warn("Close Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
        this.append(logEntry);
        if (this.out != null) {
            try {
                try {
                    this.out.write(END_OF_FILE);
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.out = null;
                    this.open = false;
                }
            }
            finally {
                this.out = null;
                this.open = false;
            }
        }
    }

    public void delete() {
        this.getRecoveryLogFile();
    }

    private void addPath(String path) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        this.paths.add(path);
    }

    private IStatus createStatus(int statusSeverity, String msg, Exception e) {
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        StringBuffer completeString = new StringBuffer("");
        if (msg != null) {
            completeString.append(msg);
        }
        if (e != null) {
            completeString.append("\r\n[");
            completeString.append(e.toString());
            completeString.append("]\r\n");
        }
        return new Status(statusSeverity, id, 0, completeString.toString(), (Throwable)e);
    }

    public IStatus removeFromFileSystem(File file) {
        String[] files;
        IStatus mainStatus = this.createStatus(0, "", null);
        MultiStatus multi = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), "", null);
        if (!file.exists()) {
            multi.add(this.createStatus(4, String.valueOf(Messages.ErrorRecoveryLog_noFiletoRemove) + file, null));
            return multi;
        }
        if (file.isDirectory() && (files = file.list()) != null) {
            int i = 0;
            while (i < files.length) {
                multi.addAll(this.removeFromFileSystem(new File(file, files[i])));
                ++i;
            }
        }
        if (!file.delete()) {
            String msg = "Unable to remove file" + file.getAbsolutePath();
            multi.add(this.createStatus(4, msg, null));
        }
        return multi;
    }
}

