/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;

public class ParagraphBlock
extends Block {
    private int blockLineCount = 0;
    private Block nestedBlock = null;
    private boolean newlinesCauseLineBreak = false;
    private final boolean testPreformattedBlocks;

    public ParagraphBlock(boolean testPreformattedBlocks) {
        this.testPreformattedBlocks = testPreformattedBlocks;
    }

    public boolean isNewlinesCauseLineBreak() {
        return this.newlinesCauseLineBreak;
    }

    public void setNewlinesCauseLineBreak(boolean newlinesCauseLineBreak) {
        this.newlinesCauseLineBreak = newlinesCauseLineBreak;
    }

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        } else if (this.nestedBlock != null) {
            int returnOffset = this.nestedBlock.processLine(line, offset);
            if (this.nestedBlock.isClosed()) {
                this.nestedBlock = null;
            }
            if (returnOffset >= 0) {
                offset = returnOffset;
                if (this.nestedBlock != null) {
                    throw new IllegalStateException();
                }
            } else {
                if (this.markupLanguage.isEmptyLine(line)) {
                    this.setClosed(true);
                    return 0;
                }
                return returnOffset;
            }
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        MediaWikiLanguage dialect = (MediaWikiLanguage)this.getMarkupLanguage();
        for (Block block : dialect.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        if (this.nestedBlock != null) {
            if (this.blockLineCount > 1) {
                this.builder.lineBreak();
            }
            this.nestedBlock.processLine(line, offset);
        } else {
            if (this.testPreformattedBlocks && offset == 0 && line.length() > 0 && line.charAt(0) == ' ') {
                this.setClosed(true);
                return 0;
            }
            if (this.blockLineCount != 1) {
                if (this.newlinesCauseLineBreak) {
                    this.builder.lineBreak();
                } else {
                    this.builder.characters("\n");
                }
            }
            dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            if (this.nestedBlock != null) {
                this.nestedBlock.setClosed(closed);
                this.nestedBlock = null;
            }
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

