/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGenerator;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformGroupDescription;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.Bundle;

public class ClassesGeneratorWizardPage
extends NewTypeWizardPage {
    public static String JPT_ECLIPSELINK_UI_PLUGIN_ID = "org.eclipse.jpt.jpa.eclipselink.ui";
    public static String XML_FILTER = "*.xml";
    public static String BINDINGS_FILE_FILTER = "*.xjb;*.xml;*.xbd";
    public static JaxbPlatformGroupDescription ECLIPSELINK_PLATFORM_GROUP = JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatformGroup("eclipselink");
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.ui.configure_jaxb_class_generation_dialog";
    private SettingsGroup settingsGroup;
    private String targetFolder;
    private String targetPackage;
    private Button usesMoxyCheckBox;
    private boolean usesMoxy;

    public ClassesGeneratorWizardPage() {
        super(true, "Classes Generator");
        this.setDescription(JptJaxbUiMessages.ClassesGeneratorWizardPage_desc);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    protected String getTargetFolder() {
        return this.targetFolder;
    }

    protected String getTargetPackage() {
        return this.targetPackage;
    }

    protected String getCatalog() {
        return this.settingsGroup.getCatalog();
    }

    protected String[] getBindingsFileNames() {
        return this.settingsGroup.getBindingsFileNames();
    }

    protected boolean usesMoxy() {
        return this.usesMoxy;
    }

    private void setUsesMoxy(boolean usesMoxy) {
        this.usesMoxy = usesMoxy;
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_CONTEXT_ID);
        this.settingsGroup = new SettingsGroup(composite);
        this.usesMoxyCheckBox = this.buildUsesMoxyCheckBox(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Button buildUsesMoxyCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 5;
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_usesMoxyImplementation);
        checkBox.setSelection(this.usesMoxy());
        checkBox.addSelectionListener(this.buildUsesMoxySelectionListener());
        return checkBox;
    }

    private SelectionListener buildUsesMoxySelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                ClassesGeneratorWizardPage.this.setUsesMoxy(ClassesGeneratorWizardPage.this.usesMoxyCheckBox.getSelection());
                ClassesGeneratorWizardPage.this.validateProjectClasspath();
            }
        };
    }

    private boolean jptEclipseLinkBundleExists() {
        return this.getJptEclipseLinkBundle() != null;
    }

    private Bundle getJptEclipseLinkBundle() {
        return Platform.getBundle((String)JPT_ECLIPSELINK_UI_PLUGIN_ID);
    }

    private void validateProjectClasspath() {
        this.setMessage(null);
        if (!this.genericJaxbIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.ClassesGeneratorWizardPage_jaxbLibrariesNotAvailable);
        } else if (this.usesMoxy() && !this.eclipseLinkMoxyIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.ClassesGeneratorWizardPage_moxyLibrariesNotAvailable);
        }
    }

    private boolean genericJaxbIsOnClasspath() {
        if (this.genericJaxbNonJdkIsOnClasspath()) {
            return true;
        }
        if (this.projectJre15OrLower()) {
            return false;
        }
        if (this.genericJaxbJdkIsOnClasspath()) {
            return true;
        }
        return this.toolsJarExists();
    }

    private boolean projectJre15OrLower() {
        String versionString;
        Float javaVersionNumber;
        String javaVersion;
        IVMInstall vm;
        block3: {
            try {
                vm = this.getVMInstall();
                if (vm != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return vm instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vm).getJavaVersion()) != null && (double)(javaVersionNumber = Float.valueOf(versionString = javaVersion.substring(0, javaVersion.lastIndexOf(46)))).floatValue() <= 1.5;
    }

    private boolean genericJaxbJdkIsOnClasspath() {
        return ClassesGenerator.genericJaxbJdkIsOnClasspath((IJavaProject)this.getJavaProject());
    }

    private boolean genericJaxbNonJdkIsOnClasspath() {
        return ClassesGenerator.genericJaxbNonJdkIsOnClasspath((IJavaProject)this.getJavaProject());
    }

    private boolean toolsJarExists() {
        return ClassesGenerator.toolsJarExists((IJavaProject)this.getJavaProject());
    }

    private IVMInstall getVMInstall() throws CoreException {
        return ClassesGenerator.getVMInstall((IJavaProject)this.getJavaProject());
    }

    private boolean moxyIsOnClasspath() {
        try {
            IType genClass = this.getJavaProject().findType("org.eclipse.persistence.jaxb.xjc.MOXyXJC");
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean eclipseLinkMoxyIsOnClasspath() {
        return this.moxyIsOnClasspath() && this.genericJaxbNonJdkIsOnClasspath();
    }

    private boolean projectPlatformIsJaxb() {
        return JptJaxbCorePlugin.getJaxbProject((IProject)this.getJavaProject().getProject()) != null;
    }

    private boolean projectJaxbPlatformIsEclipseLink() {
        JaxbPlatformGroupDescription jaxbPlatformGroup;
        JaxbPlatformDescription jaxbPlatform = JptJaxbCorePlugin.getJaxbPlatformDescription((IProject)this.getJavaProject().getProject());
        JaxbPlatformGroupDescription jaxbPlatformGroupDescription = jaxbPlatformGroup = jaxbPlatform == null ? null : jaxbPlatform.getGroup();
        return jaxbPlatformGroup == ECLIPSELINK_PLATFORM_GROUP;
    }

    private void displayWarning(String message) {
        this.setMessage(message, 2);
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (!status.matches(4)) {
            this.targetPackage = packageFragment.getElementName();
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        String srcFolder = this.getPackageFragmentRootText();
        if (!status.matches(4)) {
            this.targetFolder = srcFolder.substring(srcFolder.indexOf("/") + 1);
        }
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fContainerStatus.matches(4)) {
            this.updateStatus(this.fContainerStatus);
        } else if (!this.fPackageStatus.matches(0)) {
            this.updateStatus(this.fPackageStatus);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
        this.validateProjectClasspath();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initContainerPage((IJavaElement)((ClassesGeneratorWizard)this.getWizard()).getJavaProject());
            if (this.projectPlatformIsJaxb()) {
                this.setUsesMoxy(this.projectJaxbPlatformIsEclipseLink());
                this.usesMoxyCheckBox.setVisible(false);
            } else {
                this.setUsesMoxy(this.jptEclipseLinkBundleExists() && this.moxyIsOnClasspath());
                this.usesMoxyCheckBox.setVisible(this.jptEclipseLinkBundleExists() && !this.moxyIsOnClasspath());
            }
            this.validateProjectClasspath();
            String schemaName = ((ClassesGeneratorWizard)this.getWizard()).getLocalSchemaUri().lastSegment();
            this.setTitle(NLS.bind((String)JptJaxbUiMessages.ClassesGeneratorWizardPage_title, (Object)schemaName));
        }
    }

    protected IPackageFragmentRoot chooseContainer() {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JptJaxbUiPlugin.log(e);
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JptJaxbUiPlugin.log(e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(JptJaxbUiMessages.ClassesGeneratorWizardPage_sourceFolderSelectionDialog_title);
        dialog.setMessage(JptJaxbUiMessages.ClassesGeneratorWizardPage_chooseSourceFolderDialog_desc);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.getJavaProject());
        dialog.setInitialSelection((Object)this.getPackageFragmentRoot());
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SettingsGroup {
        private final Text catalogText;
        private final ArrayList<String> bindingsFileNames;

        private SettingsGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            ClassesGeneratorWizardPage.this.createContainerControls(composite, 4);
            ClassesGeneratorWizardPage.this.createPackageControls(composite, 4);
            Label label = new Label(composite, 258);
            GridData gridData = new GridData(4, 1, true, false, 4, 1);
            gridData.verticalIndent = 5;
            label.setLayoutData((Object)gridData);
            Label catalogLabel = new Label(composite, 0);
            catalogLabel.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_catalog);
            gridData = new GridData();
            gridData.verticalIndent = 5;
            catalogLabel.setLayoutData((Object)gridData);
            this.catalogText = this.buildCatalogText(composite);
            this.buildBrowseButton(composite);
            this.bindingsFileNames = new ArrayList();
            Label bindingsFileLabel = new Label(composite, 0);
            bindingsFileLabel.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_bindingsFiles);
            bindingsFileLabel.setLayoutData((Object)new GridData());
            this.buildBindingsFileTable(composite);
        }

        protected String getCatalog() {
            return this.catalogText.getText();
        }

        protected String[] getBindingsFileNames() {
            return (String[])ArrayTools.array(this.bindingsFileNames.iterator(), (Object[])new String[0]);
        }

        private Text buildCatalogText(Composite parent) {
            Text text = new Text(parent, 2048);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.verticalIndent = 5;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private void buildBrowseButton(Composite parent) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button browseButton = new Button(buttonComposite, 8);
            browseButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_browseButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalIndent = 5;
            gridData.grabExcessHorizontalSpace = true;
            browseButton.setLayoutData((Object)gridData);
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String filePath = SettingsGroup.this.promptXmlFile();
                    if (!StringTools.stringIsEmpty((String)filePath)) {
                        SettingsGroup.this.catalogText.setText(SettingsGroup.this.makeRelativeToProjectPath(filePath));
                    }
                }
            });
        }

        private TableViewer buildBindingsFileTable(Composite parent) {
            TableViewer tableViewer = this.buildTableViewer(parent, this.bindingsFileNames);
            this.buildAddRemoveButtons(parent, tableViewer, this.bindingsFileNames);
            return tableViewer;
        }

        private TableViewer buildTableViewer(Composite parent, ArrayList<String> tableDataModel) {
            TableLayoutComposite tableLayout = new TableLayoutComposite(parent, 0);
            this.addColumnsData(tableLayout);
            Table table = new Table((Composite)tableLayout, 68356);
            table.setLinesVisible(false);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setResizable(true);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)3);
            tableLayout.setLayoutData((Object)gridData);
            TableViewer tableViewer = new TableViewer(table);
            tableViewer.setUseHashlookup(true);
            tableViewer.setLabelProvider(this.buildLabelProvider());
            tableViewer.setContentProvider(this.buildContentProvider());
            tableViewer.setInput(tableDataModel);
            return tableViewer;
        }

        private void buildAddRemoveButtons(Composite parent, final TableViewer tableViewer, final ArrayList<String> tableDataModel) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button addButton = new Button(buttonComposite, 8);
            addButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_addButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            addButton.setLayoutData((Object)gridData);
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ArrayList filePaths = SettingsGroup.this.promptBindingsFiles();
                    for (String filePath : filePaths) {
                        SettingsGroup.this.addBindingsFile(filePath, tableDataModel);
                    }
                    tableViewer.refresh();
                }
            });
            Button removeButton = new Button(buttonComposite, 8);
            removeButton.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_removeButton);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            removeButton.setLayoutData((Object)gridData);
            removeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSelection selection = (StructuredSelection)tableViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    String bindingsFileName = (String)selection.getFirstElement();
                    SettingsGroup.this.removeBindingsFile(bindingsFileName);
                    tableViewer.refresh();
                }
            });
            addButton.setFocus();
        }

        private String makeRelativeToProjectPath(String filePath) {
            Path path = new Path(filePath);
            IPath relativePath = path.makeRelativeTo(ClassesGeneratorWizardPage.this.getJavaProject().getProject().getLocation());
            return relativePath.toOSString();
        }

        private void addBindingsFile(String filePath, ArrayList<String> tableDataModel) {
            String relativePath = this.makeRelativeToProjectPath(filePath);
            if (!tableDataModel.contains(relativePath)) {
                tableDataModel.add(relativePath);
            }
        }

        private void removeBindingsFile(String bindingsName) {
            this.bindingsFileNames.remove(bindingsName);
        }

        private IBaseLabelProvider buildLabelProvider() {
            return new TableLabelProvider();
        }

        private IContentProvider buildContentProvider() {
            return new TableContentProvider();
        }

        private String promptXmlFile() {
            String projectPath = ClassesGeneratorWizardPage.this.getJavaProject().getProject().getLocation().toString();
            FileDialog dialog = new FileDialog(ClassesGeneratorWizardPage.this.getShell());
            dialog.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_chooseACatalog);
            dialog.setFilterPath(projectPath);
            dialog.setFilterExtensions(new String[]{XML_FILTER});
            return dialog.open();
        }

        private ArrayList<String> promptBindingsFiles() {
            String projectPath = ClassesGeneratorWizardPage.this.getJavaProject().getProject().getLocation().toString();
            FileDialog dialog = new FileDialog(ClassesGeneratorWizardPage.this.getShell(), 2);
            dialog.setText(JptJaxbUiMessages.ClassesGeneratorWizardPage_chooseABindingsFile);
            dialog.setFilterPath(projectPath);
            dialog.setFilterExtensions(new String[]{BINDINGS_FILE_FILTER});
            dialog.open();
            String path = dialog.getFilterPath();
            String[] fileNames = dialog.getFileNames();
            ArrayList<String> results = new ArrayList<String>(fileNames.length);
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                results.add(String.valueOf(path) + File.separator + fileName);
                ++n2;
            }
            return results;
        }

        private void addColumnsData(TableLayoutComposite layout) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }
    }
}

