/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui.dialogs;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePickerPanel;
import org.eclipse.mylyn.internal.provisional.commons.ui.dialogs.AbstractInPlaceDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class InPlaceDateSelectionDialog
extends AbstractInPlaceDialog {
    private Date selectedDate = null;
    private String title = Messages.DateSelectionDialog_Date_Selection;
    private final Calendar initialCalendar = Calendar.getInstance();
    private boolean includeTime = true;
    private int hourOfDay = 0;

    public InPlaceDateSelectionDialog(Shell parentShell, Control openControl, Calendar initialDate, String title, boolean includeTime, int hourOfDay) {
        super(parentShell, 131072, openControl);
        this.includeTime = includeTime;
        this.hourOfDay = hourOfDay;
        if (title != null) {
            this.title = title;
        }
        if (initialDate != null) {
            this.initialCalendar.setTime(initialDate.getTime());
        }
        this.selectedDate = this.initialCalendar.getTime();
    }

    protected Control createControl(Composite parent) {
        this.getShell().setText(this.title);
        DatePickerPanel datePanel = new DatePickerPanel(parent, 0, this.initialCalendar, this.includeTime, this.hourOfDay, 3);
        datePanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    DatePickerPanel.DateSelection dateSelection = (DatePickerPanel.DateSelection)event.getSelection();
                    InPlaceDateSelectionDialog.this.selectedDate = dateSelection.getDate().getTime();
                    if (dateSelection.isDefaultSelection()) {
                        InPlaceDateSelectionDialog.this.close();
                    }
                }
            }
        });
        datePanel.setLayoutData(new GridData(0x1000000, 0x1000000, false, false));
        return datePanel;
    }

    public boolean close() {
        return super.close();
    }

    protected void createButtons(Composite composite) {
    }

    public Date getDate() {
        return this.selectedDate;
    }
}

