/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.FilterSnapshotTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LexerUtilsConstants {
    public static final int MAX_FLY_SEQUENCE_LENGTH = 5;
    public static final int MIN_LEXED_AREA_LENGTH = 4096;
    public static final int LEXED_AREA_INPUT_SIZE_FRACTION = 10;
    public static final Object INVALID_STATE = new Object();

    public static void checkLexerInputFinished(CharProvider charProvider, LexerInputOperation lexerInputOperation) {
        if (charProvider.read() != -1) {
            throw new IllegalStateException("Lexer " + lexerInputOperation.lexer() + " returned null token" + " but EOF was not read from lexer input yet." + " Fix the lexer.");
        }
        if (charProvider.readIndex() > 0) {
            throw new IllegalStateException("Lexer " + lexerInputOperation.lexer() + " returned null token but lexerInput.readLength()=" + charProvider.readIndex() + " - these characters need to be tokenized." + " Fix the lexer.");
        }
    }

    public static void tokenLengthZeroOrNegative(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Tokens with zero length are not supported by the framework. Fix the lexer.");
        }
        throw new IllegalArgumentException("Negative token length " + n);
    }

    public static void throwFlyTokenProhibited() {
        throw new IllegalStateException("Flyweight token created but prohibited. Lexer needs to check lexerInput.isFlyTokenAllowed().");
    }

    public static void throwBranchTokenFlyProhibited(AbstractToken abstractToken) {
        throw new IllegalStateException("Language embedding cannot be created for flyweight token=" + abstractToken + "\nFix the lexer to not create flyweight token instance when" + " language embedding exists for the token.");
    }

    public static void checkValidBackup(int n, int n2) {
        if (n > n2) {
            throw new IndexOutOfBoundsException("Cannot backup " + n + " characters. Maximum: " + n2 + '.');
        }
    }

    public static <T extends TokenId> Language<T> innerLanguage(LanguagePath languagePath) {
        Language<?> language = languagePath.innerLanguage();
        return language;
    }

    public static <T extends TokenId> LanguageHierarchy<T> innerLanguageHierarchy(LanguagePath languagePath) {
        Language<T> language = LexerUtilsConstants.innerLanguage(languagePath);
        return LexerApiPackageAccessor.get().languageHierarchy(language);
    }

    public static <T extends TokenId> LanguageOperation<T> innerLanguageOperation(LanguagePath languagePath) {
        Language<T> language = LexerUtilsConstants.innerLanguage(languagePath);
        return LexerApiPackageAccessor.get().languageOperation(language);
    }

    public static <T extends TokenId> LanguageEmbedding<?> findEmbedding(LanguageHierarchy<T> languageHierarchy, Token<T> token, LanguagePath languagePath, InputAttributes inputAttributes) {
        LanguageEmbedding<?> languageEmbedding = LexerSpiPackageAccessor.get().embedding(languageHierarchy, token, languagePath, inputAttributes);
        if (languageEmbedding == null) {
            languageEmbedding = LanguageManager.getInstance().findLanguageEmbedding(token, languagePath, inputAttributes);
        }
        return languageEmbedding;
    }

    public static <T extends TokenId> AbstractToken<T> token(Object object) {
        AbstractToken abstractToken = object.getClass() == EmbeddingContainer.class ? ((EmbeddingContainer)object).token() : (AbstractToken)object;
        return abstractToken;
    }

    public static <T extends TokenId> AbstractToken<T> token(TokenList<T> tokenList, int n) {
        return LexerUtilsConstants.token(tokenList.tokenOrEmbeddingContainer(n));
    }

    public static int maxLanguagePathSize(Set<LanguagePath> set) {
        int n = 0;
        for (LanguagePath languagePath : set) {
            n = Math.max(languagePath.size(), n);
        }
        return n;
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder stringBuilder, TokenList<T> tokenList) {
        return LexerUtilsConstants.appendTokenList(stringBuilder, tokenList, -1, 0, Integer.MAX_VALUE, true, 0);
    }

    public static <T extends TokenId> StringBuilder appendTokenListIndented(StringBuilder stringBuilder, TokenList<T> tokenList, int n) {
        return LexerUtilsConstants.appendTokenList(stringBuilder, tokenList, -1, 0, Integer.MAX_VALUE, false, n);
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder stringBuilder, TokenList<T> tokenList, int n, int n2, int n3, boolean bl, int n4) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        TokenHierarchy<?> tokenHierarchy = tokenList instanceof SnapshotTokenList ? ((SnapshotTokenList)tokenList).snapshot().tokenHierarchy() : null;
        n3 = Math.min(tokenList.tokenCountCurrent(), n3);
        int n5 = ArrayUtilities.digitCount((int)(n3 - 1));
        for (int i = Math.max(n2, 0); i < n3; ++i) {
            ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n4);
            stringBuilder.append(i == n ? (char)'*' : 'T');
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n5);
            LexerUtilsConstants.appendTokenInfo(stringBuilder, tokenList, i, tokenHierarchy, bl, n4);
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    public static boolean statesEqual(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public static Object endState(EmbeddedTokenList<?> embeddedTokenList) {
        int n = embeddedTokenList.tokenCount();
        return n > 0 ? embeddedTokenList.state(embeddedTokenList.tokenCount() - 1) : (embeddedTokenList.embedding().joinSections() ? INVALID_STATE : null);
    }

    public static Object endState(EmbeddedTokenList<?> embeddedTokenList, Object object) {
        int n = embeddedTokenList.tokenCount();
        return n > 0 ? embeddedTokenList.state(embeddedTokenList.tokenCount() - 1) : (embeddedTokenList.embedding().joinSections() ? object : null);
    }

    public static String idToString(TokenId tokenId) {
        return tokenId.name() + '[' + tokenId.ordinal() + ']';
    }

    public static <T extends TokenId, ET extends TokenId> TokenList<ET> embeddedTokenList(TokenList<T> tokenList, int n, Language<ET> language) {
        TokenList<ET> tokenList2 = EmbeddingContainer.embeddedTokenList(tokenList, n, language);
        if (tokenList2 != null) {
            tokenList2.embeddingContainer().updateStatus();
            TokenList<T> tokenList3 = tokenList;
            if (tokenList.getClass() == SubSequenceTokenList.class) {
                tokenList3 = ((SubSequenceTokenList)tokenList).delegate();
            }
            if (tokenList3.getClass() == FilterSnapshotTokenList.class) {
                tokenList2 = new FilterSnapshotTokenList<ET>(tokenList2, ((FilterSnapshotTokenList)tokenList3).tokenOffsetDiff());
            } else if (tokenList3.getClass() == SnapshotTokenList.class) {
                AbstractToken<T> abstractToken = LexerUtilsConstants.token(tokenList, n);
                tokenList2 = new FilterSnapshotTokenList<ET>(tokenList2, tokenList.tokenOffset(n) - ((Token)abstractToken).offset(null));
            }
            return tokenList2;
        }
        return null;
    }

    public static void appendTokenInfo(StringBuilder stringBuilder, TokenList tokenList, int n, TokenHierarchy tokenHierarchy, boolean bl, int n2) {
        LexerUtilsConstants.appendTokenInfo(stringBuilder, tokenList.tokenOrEmbeddingContainer(n), tokenList.lookahead(n), tokenList.state(n), tokenHierarchy, bl, n2);
    }

    public static void appendTokenInfo(StringBuilder stringBuilder, Object object, int n, Object object2, TokenHierarchy<?> tokenHierarchy, boolean bl, int n2) {
        if (object == null) {
            stringBuilder.append("<NULL-TOKEN>");
        } else {
            AbstractToken abstractToken;
            EmbeddingContainer embeddingContainer;
            if (object.getClass() == EmbeddingContainer.class) {
                embeddingContainer = (EmbeddingContainer)object;
                abstractToken = embeddingContainer.token();
            } else {
                embeddingContainer = null;
                abstractToken = (AbstractToken)object;
            }
            stringBuilder.append(abstractToken.dumpInfo(tokenHierarchy));
            LexerUtilsConstants.appendLAState(stringBuilder, n, object2);
            stringBuilder.append(", ");
            LexerUtilsConstants.appendIdentityHashCode(stringBuilder, abstractToken);
            if (embeddingContainer != null) {
                n2 += 4;
                stringBuilder.append("; EC-");
                LexerUtilsConstants.appendIdentityHashCode(stringBuilder, embeddingContainer);
                EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList();
                int n3 = 0;
                while (embeddedTokenList != null) {
                    stringBuilder.append('\n');
                    ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n2);
                    stringBuilder.append("Embedding[").append(n3).append("]: \"").append(embeddedTokenList.languagePath().mimePath()).append("\"\n");
                    if (bl) {
                        LexerUtilsConstants.appendTokenList(stringBuilder, embeddedTokenList, -1, 0, Integer.MAX_VALUE, bl, n2);
                    }
                    embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList();
                    ++n3;
                }
            }
        }
    }

    public static void appendIdentityHashCode(StringBuilder stringBuilder, Object object) {
        stringBuilder.append("IHC=");
        stringBuilder.append(System.identityHashCode(object));
    }

    public static void appendLAState(StringBuilder stringBuilder, TokenList<?> tokenList, int n) {
        LexerUtilsConstants.appendLAState(stringBuilder, tokenList.lookahead(n), tokenList.state(n));
    }

    public static void appendLAState(StringBuilder stringBuilder, int n, Object object) {
        if (n > 0) {
            stringBuilder.append(", la=");
            stringBuilder.append(n);
        }
        if (object != null) {
            stringBuilder.append(", st=");
            stringBuilder.append(object);
        }
    }

    private LexerUtilsConstants() {
    }
}

