/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.MissingResourceException;

public class LocaleSupport {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.localesupport");
    private static Localizer[] localizers = new Localizer[0];

    public static void addLocalizer(Localizer localizer) {
        ArrayList<Localizer> arrayList = new ArrayList<Localizer>(Arrays.asList(localizers));
        arrayList.add(localizer);
        Localizer[] localizerArray = new Localizer[arrayList.size()];
        arrayList.toArray(localizerArray);
        localizers = localizerArray;
    }

    public static void removeLocalizer(Localizer localizer) {
        ArrayList<Localizer> arrayList = new ArrayList<Localizer>(Arrays.asList(localizers));
        arrayList.remove(localizer);
        Localizer[] localizerArray = new Localizer[arrayList.size()];
        arrayList.toArray(localizerArray);
        localizers = localizerArray;
    }

    public static synchronized String getString(String string) {
        int n;
        String string2 = null;
        for (n = localizers.length - 1; n >= 0; --n) {
            try {
                string2 = localizers[n].getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
            if (string2 != null) break;
        }
        if (debug) {
            String string3 = n >= 0 ? " found in localizer=" + localizers[n] : "";
            System.err.println("LocaleSupport.getString(): key=\"" + string + "\", value=\"" + string2 + "\"" + string3);
            Thread.dumpStack();
        }
        return string2;
    }

    public static String getString(String string, String string2) {
        String string3 = LocaleSupport.getString(string);
        return string3 != null ? string3 : string2;
    }

    public static char getChar(String string, char c) {
        String string2 = LocaleSupport.getString(string);
        if (string2 == null || string2.length() < 1) {
            return c;
        }
        return string2.charAt(0);
    }

    public static interface Localizer {
        public String getString(String var1);
    }
}

