/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import java.awt.EventQueue;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class UndoRedoManager
extends UndoRedo.Manager {
    private Mutex.ExceptionAction<Object> runUndo = new Mutex.ExceptionAction<Object>(){

        public Object run() throws Exception {
            UndoRedoManager.this.superUndo();
            return null;
        }
    };
    private Mutex.ExceptionAction<Object> runRedo = new Mutex.ExceptionAction<Object>(){

        public Object run() throws Exception {
            UndoRedoManager.this.superRedo();
            return null;
        }
    };

    public void superUndo() throws CannotUndoException {
        super.undo();
    }

    public void superRedo() throws CannotRedoException {
        super.redo();
    }

    public void undo() throws CannotUndoException {
        if (EventQueue.isDispatchThread()) {
            this.superUndo();
        } else {
            try {
                Mutex.EVENT.readAccess(this.runUndo);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof CannotUndoException) {
                    throw (CannotUndoException)e;
                }
                e.printStackTrace();
            }
        }
    }

    public void redo() throws CannotRedoException {
        if (EventQueue.isDispatchThread()) {
            this.superRedo();
        } else {
            try {
                Mutex.EVENT.readAccess(this.runRedo);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof CannotRedoException) {
                    throw (CannotRedoException)e;
                }
                e.printStackTrace();
            }
        }
    }
}

