/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.utils.ExpressionInterpreter;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class OpenSubreportAction
extends NodeAction {
    public String getName() {
        return "Open Subreport";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void subreportNotFound(String msg) {
        JOptionPane.showMessageDialog(Misc.getMainFrame(), "Unable to open the subreport:\n" + msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] activatedNodes) {
        JasperDesign jasperDesign = ((ElementNode)activatedNodes[0]).getJasperDesign();
        JRDesignSubreport subreport = (JRDesignSubreport)((ElementNode)activatedNodes[0]).getElement();
        if (subreport.getExpression() == null || subreport.getExpression().getValueClassName() == null || !subreport.getExpression().getValueClassName().equals("java.lang.String")) {
            this.subreportNotFound("The subreport expression is empty.");
            return;
        }
        JRDesignDataset dataset = jasperDesign.getMainDesignDataset();
        ClassLoader classLoader = IReportManager.getReportClassLoader();
        try {
            ExpressionInterpreter interpreter = new ExpressionInterpreter(dataset, classLoader);
            Object ret = interpreter.interpretExpression(subreport.getExpression().getText());
            if (ret == null) return;
            String resourceName = ret + "";
            if (resourceName.toLowerCase().endsWith(".jasper")) {
                resourceName = resourceName.substring(0, resourceName.length() - ".jasper".length());
                resourceName = resourceName + ".jrxml";
            }
            if (!resourceName.toLowerCase().endsWith(".jrxml")) {
                throw new Exception("Unable to resolve the jrxml file for this subreport expression");
            }
            File f = new File(resourceName);
            if (!f.exists()) {
                URLClassLoader urlClassLoader;
                URL url;
                File file;
                File reportFolder = null;
                JrxmlVisualView visualView = IReportManager.getInstance().getActiveVisualView();
                if (visualView != null && (file = FileUtil.toFile((FileObject)visualView.getEditorSupport().getDataObject().getPrimaryFile())).getParentFile() != null) {
                    reportFolder = file.getParentFile();
                }
                URL[] urls = new URL[]{};
                if (reportFolder != null) {
                    urls = new URL[]{reportFolder.toURL()};
                }
                if ((url = (urlClassLoader = new URLClassLoader(urls, classLoader)).findResource(resourceName)) == null) {
                    throw new Exception(resourceName + " not found.");
                }
                f = new File(url.getPath());
                if (!f.exists()) throw new Exception(f + " not found.");
                this.openFile(f);
                return;
            } else {
                this.openFile(f);
            }
            return;
        }
        catch (Throwable ex) {
            this.subreportNotFound(ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ElementNode && ((ElementNode)activatedNodes[0]).getElement() instanceof JRDesignSubreport;
    }

    private void openFile(File f) throws Exception {
        FileObject fl = FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)f)));
        if (fl == null) {
            throw new Exception("Unable to open the file " + f);
        }
        DataObject obj = DataObject.find((FileObject)fl);
        OpenCookie ocookie = (OpenCookie)obj.getCookie(OpenCookie.class);
        if (ocookie != null) {
            ocookie.open();
        }
    }
}

